/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.selector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.selector.AbstractSelector;
import org.drools.planner.core.localsearch.decider.selector.Selector;
import org.drools.planner.core.move.Move;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeSelector
extends AbstractSelector {
    protected List<Selector> selectorList;

    public void setSelectorList(List<Selector> selectorList) {
        this.selectorList = selectorList;
    }

    @Override
    public void setDecider(Decider decider) {
        super.setDecider(decider);
        for (Selector selector : this.selectorList) {
            selector.setDecider(decider);
        }
    }

    @Override
    public void solvingStarted(LocalSearchSolverScope localSearchSolverScope) {
        for (Selector selector : this.selectorList) {
            selector.solvingStarted(localSearchSolverScope);
        }
    }

    @Override
    public void beforeDeciding(StepScope stepScope) {
        for (Selector selector : this.selectorList) {
            selector.beforeDeciding(stepScope);
        }
    }

    @Override
    public Iterator<Move> moveIterator(StepScope stepScope) {
        ArrayList<Iterator<Move>> moveIteratorList = new ArrayList<Iterator<Move>>(this.selectorList.size());
        for (Selector selector : this.selectorList) {
            Iterator<Move> moveIterator = selector.moveIterator(stepScope);
            if (!moveIterator.hasNext()) continue;
            moveIteratorList.add(moveIterator);
        }
        return new CompositeSelectorMoveIterator(stepScope.getWorkingRandom(), moveIteratorList);
    }

    @Override
    public void stepDecided(StepScope stepScope) {
        for (Selector selector : this.selectorList) {
            selector.stepDecided(stepScope);
        }
    }

    @Override
    public void stepTaken(StepScope stepScope) {
        for (Selector selector : this.selectorList) {
            selector.stepTaken(stepScope);
        }
    }

    @Override
    public void solvingEnded(LocalSearchSolverScope localSearchSolverScope) {
        for (Selector selector : this.selectorList) {
            selector.solvingEnded(localSearchSolverScope);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeSelectorMoveIterator
    implements Iterator<Move> {
        private final List<Iterator<Move>> moveIteratorList;
        private final Random workingRandom;

        public CompositeSelectorMoveIterator(Random workingRandom, List<Iterator<Move>> moveIteratorList) {
            this.moveIteratorList = moveIteratorList;
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return !this.moveIteratorList.isEmpty();
        }

        @Override
        public Move next() {
            int moveIteratorIndex = this.workingRandom.nextInt(this.moveIteratorList.size());
            Iterator<Move> moveIterator = this.moveIteratorList.get(moveIteratorIndex);
            Move next = moveIterator.next();
            if (!moveIterator.hasNext()) {
                this.moveIteratorList.remove(moveIteratorIndex);
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The remove method is not supported on CompositeSelectorMoveIterator");
        }
    }
}

