/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.selector;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.selector.AbstractSelector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.factory.MoveFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveFactorySelector
extends AbstractSelector {
    protected MoveFactory moveFactory;
    protected boolean shuffle = true;

    public void setMoveFactory(MoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    @Override
    public void setDecider(Decider decider) {
        super.setDecider(decider);
        this.moveFactory.setDecider(decider);
    }

    @Override
    public void solvingStarted(LocalSearchSolverScope localSearchSolverScope) {
        this.moveFactory.solvingStarted(localSearchSolverScope);
    }

    @Override
    public void beforeDeciding(StepScope stepScope) {
        this.moveFactory.beforeDeciding(stepScope);
    }

    @Override
    public Iterator<Move> moveIterator(StepScope stepScope) {
        return this.selectMoveList(stepScope).iterator();
    }

    public List<Move> selectMoveList(StepScope stepScope) {
        List<Move> moveList = this.moveFactory.createMoveList(stepScope.getWorkingSolution());
        if (this.shuffle) {
            Collections.shuffle(moveList, stepScope.getWorkingRandom());
        }
        return moveList;
    }

    @Override
    public void stepDecided(StepScope stepScope) {
        this.moveFactory.stepDecided(stepScope);
    }

    @Override
    public void stepTaken(StepScope stepScope) {
        this.moveFactory.stepTaken(stepScope);
    }

    @Override
    public void solvingEnded(LocalSearchSolverScope localSearchSolverScope) {
        this.moveFactory.solvingEnded(localSearchSolverScope);
    }
}

