/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.termination;

import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.localsearch.termination.AbstractTermination;

public class UnimprovedStepCountTermination
extends AbstractTermination {
    private int maximumUnimprovedStepCount = 100;

    public void setMaximumUnimprovedStepCount(int maximumUnimprovedStepCount) {
        this.maximumUnimprovedStepCount = maximumUnimprovedStepCount;
        if (maximumUnimprovedStepCount < 0) {
            throw new IllegalArgumentException("Property maximumUnimprovedStepCount (" + maximumUnimprovedStepCount + ") must be greater or equal to 0.");
        }
    }

    private int calculateUnimprovedStepCount(StepScope stepScope) {
        int bestStepIndex = stepScope.getLocalSearchSolverScope().getBestSolutionStepIndex();
        int stepIndex = stepScope.getStepIndex();
        return stepIndex - bestStepIndex;
    }

    public boolean isTerminated(StepScope stepScope) {
        int unimprovedStepCount = this.calculateUnimprovedStepCount(stepScope);
        return unimprovedStepCount >= this.maximumUnimprovedStepCount;
    }

    public double calculateTimeGradient(StepScope stepScope) {
        int unimprovedStepCount = this.calculateUnimprovedStepCount(stepScope);
        double timeGradient = (double)unimprovedStepCount / (double)this.maximumUnimprovedStepCount;
        return Math.min(timeGradient, 1.0);
    }
}

