/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score;

import org.drools.planner.core.score.AbstractScore;
import org.drools.planner.core.score.HardAndSoftScore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultHardAndSoftScore
extends AbstractScore<HardAndSoftScore>
implements HardAndSoftScore {
    private static final String HARD_LABEL = "hard";
    private static final String SOFT_LABEL = "soft";
    private final int hardScore;
    private final int softScore;

    public static DefaultHardAndSoftScore parseScore(String scoreString) {
        String[] scoreTokens = scoreString.split("hard\\/");
        if (scoreTokens.length != 2 || !scoreTokens[1].endsWith(SOFT_LABEL)) {
            throw new IllegalArgumentException("The scoreString (" + scoreString + ") doesn't follow the 999hard/999soft pattern.");
        }
        int hardScore = Integer.parseInt(scoreTokens[0]);
        int softScore = Integer.parseInt(scoreTokens[1].substring(0, scoreTokens[1].length() - SOFT_LABEL.length()));
        return DefaultHardAndSoftScore.valueOf(hardScore, softScore);
    }

    public static DefaultHardAndSoftScore valueOf(int hardScore) {
        return new DefaultHardAndSoftScore(hardScore);
    }

    public static DefaultHardAndSoftScore valueOf(int hardScore, int softScore) {
        return new DefaultHardAndSoftScore(hardScore, softScore);
    }

    public DefaultHardAndSoftScore(int hardScore) {
        this(hardScore, Integer.MIN_VALUE);
    }

    public DefaultHardAndSoftScore(int hardScore, int softScore) {
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    @Override
    public int getHardScore() {
        return this.hardScore;
    }

    @Override
    public int getSoftScore() {
        return this.softScore;
    }

    @Override
    public HardAndSoftScore add(HardAndSoftScore augment) {
        return new DefaultHardAndSoftScore(this.hardScore + augment.getHardScore(), this.softScore + augment.getSoftScore());
    }

    @Override
    public HardAndSoftScore subtract(HardAndSoftScore subtrahend) {
        return new DefaultHardAndSoftScore(this.hardScore - subtrahend.getHardScore(), this.softScore - subtrahend.getSoftScore());
    }

    @Override
    public HardAndSoftScore multiply(double multiplicand) {
        return new DefaultHardAndSoftScore((int)Math.floor((double)this.hardScore * multiplicand), (int)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public HardAndSoftScore divide(double divisor) {
        return new DefaultHardAndSoftScore((int)Math.floor((double)this.hardScore / divisor), (int)Math.floor((double)this.softScore / divisor));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardAndSoftScore) {
            HardAndSoftScore other = (HardAndSoftScore)o;
            return this.hardScore == other.getHardScore() && this.softScore == other.getSoftScore();
        }
        return false;
    }

    public int hashCode() {
        return (629 + this.hardScore) * 37 + this.softScore;
    }

    @Override
    public int compareTo(HardAndSoftScore other) {
        if (this.hardScore != other.getHardScore()) {
            if (this.hardScore < other.getHardScore()) {
                return -1;
            }
            return 1;
        }
        if (this.softScore < other.getSoftScore()) {
            return -1;
        }
        if (this.softScore > other.getSoftScore()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.hardScore + HARD_LABEL + "/" + this.softScore + SOFT_LABEL;
    }
}

