/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score;

import org.drools.planner.core.score.AbstractScore;
import org.drools.planner.core.score.SimpleScore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultSimpleScore
extends AbstractScore<SimpleScore>
implements SimpleScore {
    private final int score;

    public static DefaultSimpleScore parseScore(String scoreString) {
        return DefaultSimpleScore.valueOf(Integer.parseInt(scoreString));
    }

    public static DefaultSimpleScore valueOf(int score) {
        return new DefaultSimpleScore(score);
    }

    public DefaultSimpleScore(int score) {
        this.score = score;
    }

    @Override
    public int getScore() {
        return this.score;
    }

    @Override
    public SimpleScore add(SimpleScore augment) {
        return new DefaultSimpleScore(this.score + augment.getScore());
    }

    @Override
    public SimpleScore subtract(SimpleScore subtrahend) {
        return new DefaultSimpleScore(this.score - subtrahend.getScore());
    }

    @Override
    public SimpleScore multiply(double multiplicand) {
        return new DefaultSimpleScore((int)Math.floor((double)this.score * multiplicand));
    }

    @Override
    public SimpleScore divide(double divisor) {
        return new DefaultSimpleScore((int)Math.floor((double)this.score / divisor));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleScore) {
            SimpleScore other = (SimpleScore)o;
            return this.score == other.getScore();
        }
        return false;
    }

    public int hashCode() {
        return 629 + this.score;
    }

    @Override
    public int compareTo(SimpleScore other) {
        if (this.score < other.getScore()) {
            return -1;
        }
        if (this.score > other.getScore()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return Integer.toString(this.score);
    }
}

