/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.greatdeluge;

import java.util.Random;
import junit.framework.TestCase;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.greatdeluge.GreatDelugeAcceptor;
import org.drools.planner.core.move.DummyMove;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.DefaultSimpleScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.score.definition.SimpleScoreDefinition;

public class GreatDelugeAcceptorTest
extends TestCase {
    public void testCalculateAcceptChance() {
        GreatDelugeAcceptor acceptor = new GreatDelugeAcceptor(1.2, 0.01);
        LocalSearchSolverScope localSearchSolverScope = this.createLocalSearchSolverScope();
        acceptor.solvingStarted(localSearchSolverScope);
        StepScope stepScope = new StepScope(localSearchSolverScope);
        stepScope.setStepIndex(0);
        acceptor.beforeDeciding(stepScope);
        MoveScope a1 = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-2000));
        MoveScope a2 = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-1300));
        MoveScope a3 = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-1200));
        MoveScope b1 = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-1200));
        MoveScope b2 = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-100));
        MoveScope c1 = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-1100));
        MoveScope c2 = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-120));
        GreatDelugeAcceptorTest.assertEquals((Object)0.0, (Object)acceptor.calculateAcceptChance(a1));
        GreatDelugeAcceptorTest.assertEquals((Object)0.0, (Object)acceptor.calculateAcceptChance(a2));
        GreatDelugeAcceptorTest.assertEquals((Object)1.0, (Object)acceptor.calculateAcceptChance(a3));
    }

    private LocalSearchSolverScope createLocalSearchSolverScope() {
        LocalSearchSolverScope localSearchSolverScope = new LocalSearchSolverScope();
        localSearchSolverScope.setScoreDefinition((ScoreDefinition)new SimpleScoreDefinition());
        localSearchSolverScope.setWorkingRandom(new Random(){

            public double nextDouble() {
                return 0.2;
            }
        });
        localSearchSolverScope.setBestScore((Score)DefaultSimpleScore.valueOf((int)-1000));
        StepScope lastStepScope = new StepScope(localSearchSolverScope);
        lastStepScope.setScore((Score)DefaultSimpleScore.valueOf((int)-1000));
        localSearchSolverScope.setLastCompletedStepScope(lastStepScope);
        return localSearchSolverScope;
    }

    public MoveScope createMoveScope(StepScope stepScope, Score score) {
        MoveScope moveScope = new MoveScope(stepScope);
        moveScope.setMove((Move)new DummyMove());
        moveScope.setScore(score);
        return moveScope;
    }
}

