/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.forager;

import java.util.Comparator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.forager.AcceptedForager;
import org.drools.planner.core.localsearch.decider.forager.PickEarlyByScore;
import org.drools.planner.core.move.DummyMove;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.DefaultSimpleScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.comparator.NaturalScoreComparator;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.score.definition.SimpleScoreDefinition;

public class AcceptedForagerTest
extends TestCase {
    public void testDummy() {
    }

    public void testPickMoveMaxScoreOfAll() {
        AcceptedForager forager = new AcceptedForager(PickEarlyByScore.NONE, false);
        LocalSearchSolverScope localSearchSolverScope = this.createLocalSearchSolverScope();
        forager.solvingStarted(localSearchSolverScope);
        StepScope stepScope = this.createStepScope(localSearchSolverScope);
        forager.beforeDeciding(stepScope);
        MoveScope a = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-20), 30.0);
        MoveScope b = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 9.0);
        MoveScope c = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-20), 20.0);
        MoveScope d = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-300), 50000.0);
        MoveScope e = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 1.0);
        forager.addMove(a);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(e);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        MoveScope pickedScope = forager.pickMove(stepScope);
        AcceptedForagerTest.assertSame((Object)b, (Object)pickedScope);
        List topList = forager.getTopList(3);
        AcceptedForagerTest.assertTrue((boolean)topList.contains(a.getMove()));
        AcceptedForagerTest.assertTrue((boolean)topList.contains(b.getMove()));
        AcceptedForagerTest.assertFalse((boolean)topList.contains(c.getMove()));
        AcceptedForagerTest.assertFalse((boolean)topList.contains(d.getMove()));
        AcceptedForagerTest.assertTrue((boolean)topList.contains(e.getMove()));
        forager.solvingEnded(localSearchSolverScope);
    }

    public void testPickMoveFirstBestScoreImproving() {
        AcceptedForager forager = new AcceptedForager(PickEarlyByScore.FIRST_BEST_SCORE_IMPROVING, false);
        LocalSearchSolverScope localSearchSolverScope = this.createLocalSearchSolverScope();
        forager.solvingStarted(localSearchSolverScope);
        StepScope stepScope = this.createStepScope(localSearchSolverScope);
        forager.beforeDeciding(stepScope);
        MoveScope a = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 0.0);
        MoveScope b = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-20), 1.0);
        MoveScope c = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-300), 1.0);
        MoveScope d = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 0.3);
        forager.addMove(a);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        AcceptedForagerTest.assertTrue((boolean)forager.isQuitEarly());
        MoveScope pickedScope = forager.pickMove(stepScope);
        AcceptedForagerTest.assertSame((Object)d, (Object)pickedScope);
        List topList = forager.getTopList(2);
        AcceptedForagerTest.assertTrue((boolean)topList.contains(b.getMove()));
        AcceptedForagerTest.assertTrue((boolean)topList.contains(d.getMove()));
        forager.solvingEnded(localSearchSolverScope);
    }

    public void testPickMoveFirstLastStepScoreImproving() {
        AcceptedForager forager = new AcceptedForager(PickEarlyByScore.FIRST_LAST_STEP_SCORE_IMPROVING, false);
        LocalSearchSolverScope localSearchSolverScope = this.createLocalSearchSolverScope();
        forager.solvingStarted(localSearchSolverScope);
        StepScope stepScope = this.createStepScope(localSearchSolverScope);
        forager.beforeDeciding(stepScope);
        MoveScope a = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 0.0);
        MoveScope b = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-300), 1.0);
        MoveScope c = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-4000), 1.0);
        MoveScope d = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-20), 0.3);
        forager.addMove(a);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        AcceptedForagerTest.assertTrue((boolean)forager.isQuitEarly());
        MoveScope pickedScope = forager.pickMove(stepScope);
        AcceptedForagerTest.assertSame((Object)d, (Object)pickedScope);
        List topList = forager.getTopList(2);
        AcceptedForagerTest.assertTrue((boolean)topList.contains(b.getMove()));
        AcceptedForagerTest.assertTrue((boolean)topList.contains(d.getMove()));
        forager.solvingEnded(localSearchSolverScope);
    }

    public void testPickMoveRandomly() {
        AcceptedForager forager = new AcceptedForager(PickEarlyByScore.NONE, true);
        LocalSearchSolverScope localSearchSolverScope = this.createLocalSearchSolverScope();
        forager.solvingStarted(localSearchSolverScope);
        StepScope stepScope = this.createStepScope(localSearchSolverScope);
        forager.beforeDeciding(stepScope);
        MoveScope a = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-20), 0.0);
        MoveScope b = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 0.1);
        MoveScope c = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 0.0);
        MoveScope d = this.createMoveScope(stepScope, (Score)DefaultSimpleScore.valueOf((int)-20), 0.3);
        forager.addMove(a);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        AcceptedForagerTest.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        AcceptedForagerTest.assertTrue((boolean)forager.isQuitEarly());
        MoveScope pickedScope = forager.pickMove(stepScope);
        AcceptedForagerTest.assertSame((Object)d, (Object)pickedScope);
        List topList = forager.getTopList(2);
        AcceptedForagerTest.assertTrue((boolean)topList.contains(b.getMove()));
        AcceptedForagerTest.assertTrue((boolean)topList.contains(d.getMove()));
        forager.solvingEnded(localSearchSolverScope);
    }

    private LocalSearchSolverScope createLocalSearchSolverScope() {
        LocalSearchSolverScope localSearchSolverScope = new LocalSearchSolverScope();
        localSearchSolverScope.setScoreDefinition((ScoreDefinition)new SimpleScoreDefinition());
        localSearchSolverScope.setWorkingRandom(new Random(){

            public double nextDouble() {
                return 0.2;
            }
        });
        localSearchSolverScope.setBestScore((Score)DefaultSimpleScore.valueOf((int)-10));
        StepScope lastStepScope = new StepScope(localSearchSolverScope);
        lastStepScope.setScore((Score)DefaultSimpleScore.valueOf((int)-100));
        localSearchSolverScope.setLastCompletedStepScope(lastStepScope);
        return localSearchSolverScope;
    }

    private StepScope createStepScope(LocalSearchSolverScope localSearchSolverScope) {
        StepScope stepScope = new StepScope(localSearchSolverScope);
        stepScope.setDeciderScoreComparator((Comparator)new NaturalScoreComparator());
        return stepScope;
    }

    public MoveScope createMoveScope(StepScope stepScope, Score score, double acceptChance) {
        MoveScope moveScope = new MoveScope(stepScope);
        moveScope.setMove((Move)new DummyMove());
        moveScope.setScore(score);
        moveScope.setAcceptChance(acceptChance);
        return moveScope;
    }
}

