/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.statistic;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.drools.planner.benchmark.statistic.BestScoreStatisticListener;
import org.drools.planner.benchmark.statistic.BestScoreStatisticPoint;
import org.drools.planner.benchmark.statistic.MillisecondsSpendNumberFormat;
import org.drools.planner.benchmark.statistic.SolverStatistic;
import org.drools.planner.core.Solver;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BestScoreStatistic
implements SolverStatistic {
    private List<String> configNameList = new ArrayList<String>();
    private Map<String, BestScoreStatisticListener> bestScoreStatisticListenerMap = new HashMap<String, BestScoreStatisticListener>();
    private ScoreDefinition scoreDefinition = null;

    @Override
    public void addListener(Solver solver, String configName) {
        if (this.configNameList.contains(configName)) {
            throw new IllegalArgumentException("Cannot add a listener with the same configName (" + configName + ") twice.");
        }
        this.configNameList.add(configName);
        BestScoreStatisticListener bestScoreStatisticListener = new BestScoreStatisticListener();
        solver.addEventListener(bestScoreStatisticListener);
        this.bestScoreStatisticListenerMap.put(configName, bestScoreStatisticListener);
        if (this.scoreDefinition == null) {
            this.scoreDefinition = solver.getScoreDefinition();
        } else if (!this.scoreDefinition.getClass().equals(solver.getScoreDefinition().getClass())) {
            throw new IllegalStateException("The scoreDefinition (" + solver.getScoreDefinition() + ") should be of the same class as the other scoreDefinition (" + this.scoreDefinition + ")");
        }
    }

    @Override
    public void removeListener(Solver solver, String configName) {
        BestScoreStatisticListener bestScoreStatisticListener = this.bestScoreStatisticListenerMap.get(configName);
        solver.removeEventListener(bestScoreStatisticListener);
    }

    @Override
    public CharSequence writeStatistic(File solverStatisticFilesDirectory, String baseName) {
        StringBuilder htmlFragment = new StringBuilder();
        htmlFragment.append(this.writeCsvStatistic(solverStatisticFilesDirectory, baseName));
        htmlFragment.append(this.writeGraphStatistic(solverStatisticFilesDirectory, baseName));
        return htmlFragment;
    }

    private List<TimeToBestScoresLine> extractTimeToBestScoresLineList() {
        HashMap<Long, TimeToBestScoresLine> timeToBestScoresLineMap = new HashMap<Long, TimeToBestScoresLine>();
        for (Map.Entry<String, BestScoreStatisticListener> listenerEntry : this.bestScoreStatisticListenerMap.entrySet()) {
            String configName = listenerEntry.getKey();
            List<BestScoreStatisticPoint> statisticPointList = listenerEntry.getValue().getBestScoreStatisticPointList();
            for (BestScoreStatisticPoint statisticPoint : statisticPointList) {
                long timeMillisSpend = statisticPoint.getTimeMillisSpend();
                TimeToBestScoresLine line = (TimeToBestScoresLine)timeToBestScoresLineMap.get(timeMillisSpend);
                if (line == null) {
                    line = new TimeToBestScoresLine(timeMillisSpend);
                    timeToBestScoresLineMap.put(timeMillisSpend, line);
                }
                line.getConfigNameToScoreMap().put(configName, statisticPoint.getScore());
            }
        }
        ArrayList<TimeToBestScoresLine> timeToBestScoresLineList = new ArrayList<TimeToBestScoresLine>(timeToBestScoresLineMap.values());
        Collections.sort(timeToBestScoresLineList);
        return timeToBestScoresLineList;
    }

    private CharSequence writeCsvStatistic(File solverStatisticFilesDirectory, String baseName) {
        List<TimeToBestScoresLine> timeToBestScoresLineList = this.extractTimeToBestScoresLineList();
        File csvStatisticFile = new File(solverStatisticFilesDirectory, baseName + "Statistic.csv");
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(csvStatisticFile), "utf-8");
            ((Writer)writer).append("\"TimeMillisSpend\"");
            for (String configName : this.configNameList) {
                ((Writer)writer).append(",\"").append(configName.replaceAll("\\\"", "\\\"")).append("\"");
            }
            ((Writer)writer).append("\n");
            for (TimeToBestScoresLine timeToBestScoresLine : timeToBestScoresLineList) {
                writer.write(Long.toString(timeToBestScoresLine.getTimeMillisSpend()));
                for (String configName : this.configNameList) {
                    Double scoreGraphValue;
                    ((Writer)writer).append(",");
                    Score score = timeToBestScoresLine.getConfigNameToScoreMap().get(configName);
                    if (score == null || (scoreGraphValue = this.scoreDefinition.translateScoreToGraphValue(score)) == null) continue;
                    ((Writer)writer).append(scoreGraphValue.toString());
                }
                ((Writer)writer).append("\n");
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing csvStatisticFile: " + csvStatisticFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        return "  <p><a href=\"" + csvStatisticFile.getName() + "\">CVS file</a></p>\n";
    }

    private CharSequence writeGraphStatistic(File solverStatisticFilesDirectory, String baseName) {
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        for (Map.Entry<String, BestScoreStatisticListener> listenerEntry : this.bestScoreStatisticListenerMap.entrySet()) {
            String configName = listenerEntry.getKey();
            XYSeries configSeries = new XYSeries((Comparable)((Object)configName));
            List<BestScoreStatisticPoint> statisticPointList = listenerEntry.getValue().getBestScoreStatisticPointList();
            for (BestScoreStatisticPoint statisticPoint : statisticPointList) {
                long timeMillisSpend = statisticPoint.getTimeMillisSpend();
                Score score = statisticPoint.getScore();
                Double scoreGraphValue = this.scoreDefinition.translateScoreToGraphValue(score);
                if (scoreGraphValue == null) continue;
                configSeries.add((double)timeMillisSpend, (Number)scoreGraphValue);
            }
            seriesCollection.addSeries(configSeries);
        }
        NumberAxis xAxis = new NumberAxis("Time millis spend");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpendNumberFormat());
        NumberAxis yAxis = new NumberAxis("Score");
        yAxis.setAutoRangeIncludesZero(false);
        XYStepRenderer renderer = new XYStepRenderer();
        XYPlot plot = new XYPlot((XYDataset)seriesCollection, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart(baseName + " best score statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File graphStatisticFile = new File(solverStatisticFilesDirectory, baseName + "Statistic.png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(graphStatisticFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing graphStatisticFile: " + graphStatisticFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return "  <img src=\"" + graphStatisticFile.getName() + "\"/>\n";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TimeToBestScoresLine
    implements Comparable<TimeToBestScoresLine> {
        private long timeMillisSpend;
        private Map<String, Score> configNameToScoreMap;

        public TimeToBestScoresLine(long timeMillisSpend) {
            this.timeMillisSpend = timeMillisSpend;
            this.configNameToScoreMap = new HashMap<String, Score>();
        }

        public long getTimeMillisSpend() {
            return this.timeMillisSpend;
        }

        public Map<String, Score> getConfigNameToScoreMap() {
            return this.configNameToScoreMap;
        }

        @Override
        public int compareTo(TimeToBestScoresLine other) {
            return this.timeMillisSpend < other.timeMillisSpend ? -1 : (this.timeMillisSpend > other.timeMillisSpend ? 1 : 0);
        }
    }
}

