/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.localsearch;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.drools.planner.config.AbstractSolverConfig;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.localsearch.decider.acceptor.AcceptorConfig;
import org.drools.planner.config.localsearch.decider.deciderscorecomparator.DeciderScoreComparatorFactoryConfig;
import org.drools.planner.config.localsearch.decider.forager.ForagerConfig;
import org.drools.planner.config.localsearch.decider.selector.SelectorConfig;
import org.drools.planner.config.localsearch.termination.TerminationConfig;
import org.drools.planner.core.localsearch.DefaultLocalSearchSolver;
import org.drools.planner.core.localsearch.LocalSearchSolver;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.DefaultDecider;
import org.drools.planner.core.score.definition.ScoreDefinition;

@XStreamAlias(value="localSearchSolver")
public class LocalSearchSolverConfig
extends AbstractSolverConfig {
    @XStreamAlias(value="termination")
    private TerminationConfig terminationConfig = new TerminationConfig();
    @XStreamAlias(value="deciderScoreComparatorFactory")
    private DeciderScoreComparatorFactoryConfig deciderScoreComparatorFactoryConfig = new DeciderScoreComparatorFactoryConfig();
    @XStreamAlias(value="selector")
    private SelectorConfig selectorConfig = new SelectorConfig();
    @XStreamAlias(value="acceptor")
    private AcceptorConfig acceptorConfig = new AcceptorConfig();
    @XStreamAlias(value="forager")
    private ForagerConfig foragerConfig = new ForagerConfig();

    public TerminationConfig getTerminationConfig() {
        return this.terminationConfig;
    }

    public void setTerminationConfig(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
    }

    public DeciderScoreComparatorFactoryConfig getDeciderScoreComparatorFactoryConfig() {
        return this.deciderScoreComparatorFactoryConfig;
    }

    public void setDeciderScoreComparatorFactoryConfig(DeciderScoreComparatorFactoryConfig deciderScoreComparatorFactoryConfig) {
        this.deciderScoreComparatorFactoryConfig = deciderScoreComparatorFactoryConfig;
    }

    public SelectorConfig getSelectorConfig() {
        return this.selectorConfig;
    }

    public void setSelectorConfig(SelectorConfig selectorConfig) {
        this.selectorConfig = selectorConfig;
    }

    public AcceptorConfig getAcceptorConfig() {
        return this.acceptorConfig;
    }

    public void setAcceptorConfig(AcceptorConfig acceptorConfig) {
        this.acceptorConfig = acceptorConfig;
    }

    public ForagerConfig getForagerConfig() {
        return this.foragerConfig;
    }

    public void setForagerConfig(ForagerConfig foragerConfig) {
        this.foragerConfig = foragerConfig;
    }

    public LocalSearchSolver buildSolver() {
        DefaultLocalSearchSolver localSearchSolver = new DefaultLocalSearchSolver();
        this.configureAbstractSolver(localSearchSolver);
        localSearchSolver.setTermination(this.terminationConfig.buildTermination(localSearchSolver.getScoreDefinition()));
        localSearchSolver.setDecider(this.buildDecider(localSearchSolver.getScoreDefinition()));
        if (this.environmentMode == EnvironmentMode.DEBUG || this.environmentMode == EnvironmentMode.TRACE) {
            localSearchSolver.setAssertStepScoreIsUncorrupted(true);
        }
        return localSearchSolver;
    }

    private Decider buildDecider(ScoreDefinition scoreDefinition) {
        DefaultDecider decider = new DefaultDecider();
        decider.setDeciderScoreComparator(this.deciderScoreComparatorFactoryConfig.buildDeciderScoreComparatorFactory());
        decider.setSelector(this.selectorConfig.buildSelector(scoreDefinition));
        decider.setAcceptor(this.acceptorConfig.buildAcceptor(scoreDefinition));
        decider.setForager(this.foragerConfig.buildForager(scoreDefinition));
        if (this.environmentMode == EnvironmentMode.TRACE) {
            decider.setAssertMoveScoreIsUncorrupted(true);
        }
        if (this.environmentMode == EnvironmentMode.DEBUG || this.environmentMode == EnvironmentMode.TRACE) {
            decider.setAssertUndoMoveIsUncorrupted(true);
        }
        return decider;
    }

    public void inherit(LocalSearchSolverConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.terminationConfig == null) {
            this.terminationConfig = inheritedConfig.getTerminationConfig();
        } else if (inheritedConfig.getTerminationConfig() != null) {
            this.terminationConfig.inherit(inheritedConfig.getTerminationConfig());
        }
        if (this.deciderScoreComparatorFactoryConfig == null) {
            this.deciderScoreComparatorFactoryConfig = inheritedConfig.getDeciderScoreComparatorFactoryConfig();
        } else if (inheritedConfig.getDeciderScoreComparatorFactoryConfig() != null) {
            this.deciderScoreComparatorFactoryConfig.inherit(inheritedConfig.getDeciderScoreComparatorFactoryConfig());
        }
        if (this.selectorConfig == null) {
            this.selectorConfig = inheritedConfig.getSelectorConfig();
        } else if (inheritedConfig.getSelectorConfig() != null) {
            this.selectorConfig.inherit(inheritedConfig.getSelectorConfig());
        }
        if (this.acceptorConfig == null) {
            this.acceptorConfig = inheritedConfig.getAcceptorConfig();
        } else if (inheritedConfig.getAcceptorConfig() != null) {
            this.acceptorConfig.inherit(inheritedConfig.getAcceptorConfig());
        }
        if (this.foragerConfig == null) {
            this.foragerConfig = inheritedConfig.getForagerConfig();
        } else if (inheritedConfig.getForagerConfig() != null) {
            this.foragerConfig.inherit(inheritedConfig.getForagerConfig());
        }
    }
}

