/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.localsearch.decider.acceptor;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.drools.planner.core.localsearch.decider.acceptor.Acceptor;
import org.drools.planner.core.localsearch.decider.acceptor.CompositeAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.greatdeluge.GreatDelugeAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.simulatedannealing.SimulatedAnnealingAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.MoveTabuAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.PropertyTabuAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.SolutionTabuAcceptor;
import org.drools.planner.core.score.definition.ScoreDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="acceptor")
public class AcceptorConfig {
    private Acceptor acceptor = null;
    private Class<Acceptor> acceptorClass = null;
    @XStreamImplicit(itemFieldName="acceptorType")
    private List<AcceptorType> acceptorTypeList = null;
    protected Integer completeMoveTabuSize = null;
    protected Integer partialMoveTabuSize = null;
    protected Integer completeUndoMoveTabuSize = null;
    protected Integer partialUndoMoveTabuSize = null;
    protected Integer completePropertyTabuSize = null;
    protected Integer partialPropertyTabuSize = null;
    protected Integer completeSolutionTabuSize = null;
    protected Integer partialSolutionTabuSize = null;
    protected String simulatedAnnealingStartingTemperature = null;
    protected Double greatDelugeWaterLevelUpperBoundRate = null;
    protected Double greatDelugeWaterRisingRate = null;

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    public void setAcceptor(Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    public Class<Acceptor> getAcceptorClass() {
        return this.acceptorClass;
    }

    public void setAcceptorClass(Class<Acceptor> acceptorClass) {
        this.acceptorClass = acceptorClass;
    }

    public List<AcceptorType> getAcceptorTypeList() {
        return this.acceptorTypeList;
    }

    public void setAcceptorTypeList(List<AcceptorType> acceptorTypeList) {
        this.acceptorTypeList = acceptorTypeList;
    }

    public Integer getCompleteMoveTabuSize() {
        return this.completeMoveTabuSize;
    }

    public void setCompleteMoveTabuSize(Integer completeMoveTabuSize) {
        this.completeMoveTabuSize = completeMoveTabuSize;
    }

    public Integer getPartialMoveTabuSize() {
        return this.partialMoveTabuSize;
    }

    public void setPartialMoveTabuSize(Integer partialMoveTabuSize) {
        this.partialMoveTabuSize = partialMoveTabuSize;
    }

    public Integer getCompleteUndoMoveTabuSize() {
        return this.completeUndoMoveTabuSize;
    }

    public void setCompleteUndoMoveTabuSize(Integer completeUndoMoveTabuSize) {
        this.completeUndoMoveTabuSize = completeUndoMoveTabuSize;
    }

    public Integer getPartialUndoMoveTabuSize() {
        return this.partialUndoMoveTabuSize;
    }

    public void setPartialUndoMoveTabuSize(Integer partialUndoMoveTabuSize) {
        this.partialUndoMoveTabuSize = partialUndoMoveTabuSize;
    }

    public Integer getCompletePropertyTabuSize() {
        return this.completePropertyTabuSize;
    }

    public void setCompletePropertyTabuSize(Integer completePropertyTabuSize) {
        this.completePropertyTabuSize = completePropertyTabuSize;
    }

    public Integer getPartialPropertyTabuSize() {
        return this.partialPropertyTabuSize;
    }

    public void setPartialPropertyTabuSize(Integer partialPropertyTabuSize) {
        this.partialPropertyTabuSize = partialPropertyTabuSize;
    }

    public Integer getCompleteSolutionTabuSize() {
        return this.completeSolutionTabuSize;
    }

    public void setCompleteSolutionTabuSize(Integer completeSolutionTabuSize) {
        this.completeSolutionTabuSize = completeSolutionTabuSize;
    }

    public Integer getPartialSolutionTabuSize() {
        return this.partialSolutionTabuSize;
    }

    public void setPartialSolutionTabuSize(Integer partialSolutionTabuSize) {
        this.partialSolutionTabuSize = partialSolutionTabuSize;
    }

    public String getSimulatedAnnealingStartingTemperature() {
        return this.simulatedAnnealingStartingTemperature;
    }

    public void setSimulatedAnnealingStartingTemperature(String simulatedAnnealingStartingTemperature) {
        this.simulatedAnnealingStartingTemperature = simulatedAnnealingStartingTemperature;
    }

    public Double getGreatDelugeWaterLevelUpperBoundRate() {
        return this.greatDelugeWaterLevelUpperBoundRate;
    }

    public void setGreatDelugeWaterLevelUpperBoundRate(Double greatDelugeWaterLevelUpperBoundRate) {
        this.greatDelugeWaterLevelUpperBoundRate = greatDelugeWaterLevelUpperBoundRate;
    }

    public Double getGreatDelugeWaterRisingRate() {
        return this.greatDelugeWaterRisingRate;
    }

    public void setGreatDelugeWaterRisingRate(Double greatDelugeWaterRisingRate) {
        this.greatDelugeWaterRisingRate = greatDelugeWaterRisingRate;
    }

    public Acceptor buildAcceptor(ScoreDefinition scoreDefinition) {
        ArrayList<Acceptor> acceptorList = new ArrayList<Acceptor>();
        if (this.acceptor != null) {
            acceptorList.add(this.acceptor);
        }
        if (this.acceptorClass != null) {
            try {
                acceptorList.add(this.acceptorClass.newInstance());
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("acceptorClass (" + this.acceptorClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("acceptorClass (" + this.acceptorClass.getName() + ") does not have a public no-arg constructor", e);
            }
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.MOVE_TABU) || this.completeMoveTabuSize != null || this.partialMoveTabuSize != null) {
            MoveTabuAcceptor moveTabuAcceptor = new MoveTabuAcceptor();
            moveTabuAcceptor.setUseUndoMoveAsTabuMove(false);
            if (this.completeMoveTabuSize != null) {
                moveTabuAcceptor.setCompleteTabuSize(this.completeMoveTabuSize);
            }
            if (this.partialMoveTabuSize != null) {
                moveTabuAcceptor.setPartialTabuSize(this.partialMoveTabuSize);
            }
            acceptorList.add(moveTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.UNDO_MOVE_TABU) || this.completeUndoMoveTabuSize != null || this.partialUndoMoveTabuSize != null) {
            MoveTabuAcceptor undoMoveTabuAcceptor = new MoveTabuAcceptor();
            undoMoveTabuAcceptor.setUseUndoMoveAsTabuMove(true);
            if (this.completeUndoMoveTabuSize != null) {
                undoMoveTabuAcceptor.setCompleteTabuSize(this.completeUndoMoveTabuSize);
            }
            if (this.partialUndoMoveTabuSize != null) {
                undoMoveTabuAcceptor.setPartialTabuSize(this.partialUndoMoveTabuSize);
            }
            acceptorList.add(undoMoveTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.PROPERTY_TABU) || this.completePropertyTabuSize != null || this.partialPropertyTabuSize != null) {
            PropertyTabuAcceptor propertyTabuAcceptor = new PropertyTabuAcceptor();
            if (this.completePropertyTabuSize != null) {
                propertyTabuAcceptor.setCompleteTabuSize(this.completePropertyTabuSize);
            }
            if (this.partialPropertyTabuSize != null) {
                propertyTabuAcceptor.setPartialTabuSize(this.partialPropertyTabuSize);
            }
            acceptorList.add(propertyTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.SOLUTION_TABU) || this.completeSolutionTabuSize != null || this.partialSolutionTabuSize != null) {
            SolutionTabuAcceptor solutionTabuAcceptor = new SolutionTabuAcceptor();
            if (this.completeSolutionTabuSize != null) {
                solutionTabuAcceptor.setCompleteTabuSize(this.completeSolutionTabuSize);
            }
            if (this.partialSolutionTabuSize != null) {
                solutionTabuAcceptor.setPartialTabuSize(this.partialSolutionTabuSize);
            }
            acceptorList.add(solutionTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.SIMULATED_ANNEALING) || this.simulatedAnnealingStartingTemperature != null) {
            SimulatedAnnealingAcceptor simulatedAnnealingAcceptor = new SimulatedAnnealingAcceptor();
            simulatedAnnealingAcceptor.setStartingTemperature(scoreDefinition.parseScore(this.simulatedAnnealingStartingTemperature));
            acceptorList.add(simulatedAnnealingAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.GREAT_DELUGE) || this.greatDelugeWaterLevelUpperBoundRate != null || this.greatDelugeWaterRisingRate != null) {
            double waterLevelUpperBoundRate = (Double)ObjectUtils.defaultIfNull((Object)this.greatDelugeWaterLevelUpperBoundRate, (Object)1.2);
            double waterRisingRate = (Double)ObjectUtils.defaultIfNull((Object)this.greatDelugeWaterRisingRate, (Object)1.0E-7);
            acceptorList.add(new GreatDelugeAcceptor(waterLevelUpperBoundRate, waterRisingRate));
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.LATE_ACCEPTANCE)) {
            throw new UnsupportedOperationException("LATE_ACCEPTANCE not yet supported.");
        }
        if (acceptorList.size() == 1) {
            return (Acceptor)acceptorList.get(0);
        }
        if (acceptorList.size() > 1) {
            CompositeAcceptor compositeAcceptor = new CompositeAcceptor();
            compositeAcceptor.setAcceptorList(acceptorList);
            return compositeAcceptor;
        }
        SolutionTabuAcceptor solutionTabuAcceptor = new SolutionTabuAcceptor();
        solutionTabuAcceptor.setCompleteTabuSize(1500);
        return solutionTabuAcceptor;
    }

    public void inherit(AcceptorConfig inheritedConfig) {
        if (this.acceptor == null) {
            this.acceptor = inheritedConfig.getAcceptor();
        }
        if (this.acceptorClass == null) {
            this.acceptorClass = inheritedConfig.getAcceptorClass();
        }
        if (this.acceptorTypeList == null) {
            this.acceptorTypeList = inheritedConfig.getAcceptorTypeList();
        } else {
            List<AcceptorType> inheritedAcceptorTypeList = inheritedConfig.getAcceptorTypeList();
            if (inheritedAcceptorTypeList != null) {
                for (AcceptorType acceptorType : inheritedAcceptorTypeList) {
                    if (this.acceptorTypeList.contains((Object)acceptorType)) continue;
                    this.acceptorTypeList.add(acceptorType);
                }
            }
        }
        if (this.completeMoveTabuSize == null) {
            this.completeMoveTabuSize = inheritedConfig.getCompleteMoveTabuSize();
        }
        if (this.partialMoveTabuSize == null) {
            this.partialMoveTabuSize = inheritedConfig.getPartialMoveTabuSize();
        }
        if (this.completeUndoMoveTabuSize == null) {
            this.completeUndoMoveTabuSize = inheritedConfig.getCompleteUndoMoveTabuSize();
        }
        if (this.partialUndoMoveTabuSize == null) {
            this.partialUndoMoveTabuSize = inheritedConfig.getPartialUndoMoveTabuSize();
        }
        if (this.completePropertyTabuSize == null) {
            this.completePropertyTabuSize = inheritedConfig.getCompletePropertyTabuSize();
        }
        if (this.partialPropertyTabuSize == null) {
            this.partialPropertyTabuSize = inheritedConfig.getPartialPropertyTabuSize();
        }
        if (this.completeSolutionTabuSize == null) {
            this.completeSolutionTabuSize = inheritedConfig.getCompleteSolutionTabuSize();
        }
        if (this.partialSolutionTabuSize == null) {
            this.partialSolutionTabuSize = inheritedConfig.getPartialSolutionTabuSize();
        }
        if (this.simulatedAnnealingStartingTemperature == null) {
            this.simulatedAnnealingStartingTemperature = inheritedConfig.getSimulatedAnnealingStartingTemperature();
        }
        if (this.greatDelugeWaterLevelUpperBoundRate == null) {
            this.greatDelugeWaterLevelUpperBoundRate = inheritedConfig.getGreatDelugeWaterLevelUpperBoundRate();
        }
        if (this.greatDelugeWaterRisingRate == null) {
            this.greatDelugeWaterRisingRate = inheritedConfig.getGreatDelugeWaterRisingRate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AcceptorType {
        MOVE_TABU,
        UNDO_MOVE_TABU,
        PROPERTY_TABU,
        SOLUTION_TABU,
        SIMULATED_ANNEALING,
        LATE_ACCEPTANCE,
        GREAT_DELUGE;

    }
}

