/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.bestsolution;

import org.drools.planner.core.event.SolverEventSupport;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.AbstractSolverLifecycleListener;
import org.drools.planner.core.solver.AbstractSolverScope;
import org.drools.planner.core.solver.AbstractStepScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestSolutionRecaller
implements AbstractSolverLifecycleListener {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolverEventSupport solverEventSupport;

    public void setSolverEventSupport(SolverEventSupport solverEventSupport) {
        this.solverEventSupport = solverEventSupport;
    }

    public void solvingStarted(AbstractSolverScope abstractSolverScope) {
        Score initialScore = abstractSolverScope.calculateScoreFromWorkingMemory();
        abstractSolverScope.setStartingScore(initialScore);
        abstractSolverScope.setBestSolutionStepIndex(-1);
        Solution newBestSolution = abstractSolverScope.getWorkingSolution().cloneSolution();
        abstractSolverScope.setBestSolution(newBestSolution);
        abstractSolverScope.setBestScore(initialScore);
        this.solverEventSupport.fireBestSolutionChanged(newBestSolution);
    }

    public void stepTaken(AbstractStepScope abstractStepScope) {
        Score bestScore;
        AbstractSolverScope abstractSolverScope = abstractStepScope.getAbstractSolverScope();
        Score newScore = abstractStepScope.getScore();
        boolean bestScoreImproved = newScore.compareTo(bestScore = abstractSolverScope.getBestScore()) > 0;
        abstractStepScope.setBestScoreImproved(bestScoreImproved);
        if (bestScoreImproved) {
            abstractSolverScope.setBestSolutionStepIndex(abstractStepScope.getStepIndex());
            Solution newBestSolution = abstractStepScope.createOrGetClonedSolution();
            abstractSolverScope.setBestSolution(newBestSolution);
            abstractSolverScope.setBestScore((Score)newBestSolution.getScore());
            this.solverEventSupport.fireBestSolutionChanged(newBestSolution);
        }
    }

    public void solvingEnded(AbstractSolverScope abstractSolverScope) {
    }
}

