/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.bruteforce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.planner.core.annotations.PlanningVariableClass;
import org.drools.planner.core.bruteforce.BruteForceSolverScope;
import org.drools.planner.core.bruteforce.PlanningVariableHandler;

public class BruteForceSolutionIterator {
    private BruteForceSolverScope bruteForceSolverScope;
    private List<PlanningVariableHandler> list = new ArrayList<PlanningVariableHandler>();

    public BruteForceSolutionIterator(BruteForceSolverScope bruteForceSolverScope) {
        this.bruteForceSolverScope = bruteForceSolverScope;
        Collection<Object> facts = bruteForceSolverScope.getWorkingSolution().getFacts();
        for (Object fact : facts) {
            PlanningVariableClass planningVariableClass = fact.getClass().getAnnotation(PlanningVariableClass.class);
            if (planningVariableClass == null) continue;
            PlanningVariableHandler planningVariableHandler = new PlanningVariableHandler(fact, planningVariableClass, facts);
            this.list.add(planningVariableHandler);
        }
    }

    public boolean hasNext() {
        for (PlanningVariableHandler planningVariableHandler : this.list) {
            if (!planningVariableHandler.hasNext()) continue;
            return true;
        }
        return false;
    }

    public void next() {
        for (PlanningVariableHandler planningVariableHandler : this.list) {
            if (planningVariableHandler.hasNext()) {
                planningVariableHandler.next(this.bruteForceSolverScope.getWorkingMemory());
                break;
            }
            planningVariableHandler.reset(this.bruteForceSolverScope.getWorkingMemory());
        }
    }
}

