/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch;

import org.drools.planner.core.localsearch.LocalSearchSolver;
import org.drools.planner.core.localsearch.LocalSearchSolverLifecycleListener;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.termination.Termination;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.solver.AbstractSolver;
import org.drools.planner.core.solver.AbstractSolverScope;

public class DefaultLocalSearchSolver
extends AbstractSolver
implements LocalSearchSolver,
LocalSearchSolverLifecycleListener {
    protected Termination termination;
    protected Decider decider;
    protected boolean assertStepScoreIsUncorrupted = false;
    protected LocalSearchSolverScope localSearchSolverScope = new LocalSearchSolverScope();

    public void setTermination(Termination termination) {
        this.termination = termination;
        this.termination.setLocalSearchSolver(this);
    }

    public Decider getDecider() {
        return this.decider;
    }

    public void setDecider(Decider decider) {
        this.decider = decider;
        this.decider.setLocalSearchSolver(this);
    }

    public void setAssertStepScoreIsUncorrupted(boolean assertStepScoreIsUncorrupted) {
        this.assertStepScoreIsUncorrupted = assertStepScoreIsUncorrupted;
    }

    public AbstractSolverScope getAbstractSolverScope() {
        return this.localSearchSolverScope;
    }

    protected void solveImplementation() {
        LocalSearchSolverScope localSearchSolverScope = this.localSearchSolverScope;
        this.solvingStarted(localSearchSolverScope);
        LocalSearchStepScope localSearchStepScope = this.createNextStepScope(localSearchSolverScope, null);
        while (!this.terminatedEarly.get() && !this.termination.isTerminated(localSearchStepScope)) {
            localSearchStepScope.setTimeGradient(this.termination.calculateTimeGradient(localSearchStepScope));
            this.beforeDeciding(localSearchStepScope);
            this.decider.decideNextStep(localSearchStepScope);
            Move nextStep = localSearchStepScope.getStep();
            if (nextStep == null) {
                this.logger.warn("No move accepted for step index ({}) out of {} accepted moves. Terminating by exception.", (Object)localSearchStepScope.getStepIndex(), (Object)this.decider.getForager().getAcceptedMovesSize());
                break;
            }
            String nextStepString = null;
            if (this.logger.isInfoEnabled()) {
                nextStepString = nextStep.toString();
            }
            this.stepDecided(localSearchStepScope);
            nextStep.doMove(localSearchStepScope.getWorkingMemory());
            localSearchSolverScope.getWorkingSolution().setScore(localSearchStepScope.getScore());
            if (this.assertStepScoreIsUncorrupted) {
                localSearchSolverScope.assertWorkingScore(localSearchStepScope.getScore());
            }
            this.stepTaken(localSearchStepScope);
            this.logger.info("Step index ({}), time spend ({}), score ({}), {} best score ({}), accepted move size ({}) for picked step ({}).", new Object[]{localSearchStepScope.getStepIndex(), localSearchSolverScope.calculateTimeMillisSpend(), localSearchStepScope.getScore(), localSearchStepScope.getBestScoreImproved() != false ? "new" : "   ", localSearchSolverScope.getBestScore(), this.decider.getForager().getAcceptedMovesSize(), nextStepString});
            localSearchStepScope = this.createNextStepScope(localSearchSolverScope, localSearchStepScope);
        }
        this.solvingEnded(localSearchSolverScope);
    }

    private LocalSearchStepScope createNextStepScope(LocalSearchSolverScope localSearchSolverScope, LocalSearchStepScope completedLocalSearchStepScope) {
        if (completedLocalSearchStepScope == null) {
            completedLocalSearchStepScope = new LocalSearchStepScope(localSearchSolverScope);
            completedLocalSearchStepScope.setScore(localSearchSolverScope.getStartingScore());
            completedLocalSearchStepScope.setStepIndex(-1);
            completedLocalSearchStepScope.setTimeGradient(0.0);
        }
        localSearchSolverScope.setLastCompletedLocalSearchStepScope(completedLocalSearchStepScope);
        LocalSearchStepScope localSearchStepScope = new LocalSearchStepScope(localSearchSolverScope);
        localSearchStepScope.setStepIndex(completedLocalSearchStepScope.getStepIndex() + 1);
        return localSearchStepScope;
    }

    public void solvingStarted(LocalSearchSolverScope localSearchSolverScope) {
        super.solvingStarted(localSearchSolverScope);
        this.termination.solvingStarted(localSearchSolverScope);
        this.decider.solvingStarted(localSearchSolverScope);
    }

    public void beforeDeciding(LocalSearchStepScope localSearchStepScope) {
        this.termination.beforeDeciding(localSearchStepScope);
        this.decider.beforeDeciding(localSearchStepScope);
    }

    public void stepDecided(LocalSearchStepScope localSearchStepScope) {
        this.termination.stepDecided(localSearchStepScope);
        this.decider.stepDecided(localSearchStepScope);
    }

    public void stepTaken(LocalSearchStepScope localSearchStepScope) {
        this.bestSolutionRecaller.stepTaken(localSearchStepScope);
        this.termination.stepTaken(localSearchStepScope);
        this.decider.stepTaken(localSearchStepScope);
    }

    public void solvingEnded(LocalSearchSolverScope localSearchSolverScope) {
        this.decider.solvingEnded(localSearchSolverScope);
        this.termination.solvingEnded(localSearchSolverScope);
        this.bestSolutionRecaller.solvingEnded(localSearchSolverScope);
        long timeMillisSpend = localSearchSolverScope.calculateTimeMillisSpend();
        if (timeMillisSpend == 0L) {
            timeMillisSpend = 1L;
        }
        long averageCalculateCountPerSecond = localSearchSolverScope.getCalculateCount() * 1000L / timeMillisSpend;
        this.logger.info("Solved at step index ({}) with time spend ({}) for best score ({}) with average calculate count per second ({}).", new Object[]{localSearchSolverScope.getLastCompletedLocalSearchStepScope().getStepIndex(), timeMillisSpend, localSearchSolverScope.getBestScore(), averageCalculateCountPerSecond});
    }
}

