/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.forager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.forager.AbstractForager;
import org.drools.planner.core.localsearch.decider.forager.AcceptedMoveScopeComparator;
import org.drools.planner.core.localsearch.decider.forager.PickEarlyType;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.Score;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptedForager
extends AbstractForager {
    protected final PickEarlyType pickEarlyType;
    protected final int minimalAcceptedSelection;
    protected AcceptedMoveScopeComparator acceptedMoveScopeComparator;
    protected int selectedCount;
    protected List<MoveScope> acceptedList;
    protected boolean listSorted;
    protected Score maxScore;
    protected double acceptChanceMaxScoreTotal;
    protected MoveScope earlyPickedMoveScope = null;

    public AcceptedForager(PickEarlyType pickEarlyType, int minimalAcceptedSelection) {
        this.pickEarlyType = pickEarlyType;
        this.minimalAcceptedSelection = minimalAcceptedSelection;
    }

    @Override
    public void beforeDeciding(LocalSearchStepScope localSearchStepScope) {
        this.acceptedMoveScopeComparator = new AcceptedMoveScopeComparator(localSearchStepScope.getDeciderScoreComparator());
        this.selectedCount = 0;
        this.acceptedList = new ArrayList<MoveScope>(1024);
        this.listSorted = false;
        this.maxScore = localSearchStepScope.getLocalSearchSolverScope().getScoreDefinition().getPerfectMinimumScore();
        this.acceptChanceMaxScoreTotal = 0.0;
        this.earlyPickedMoveScope = null;
    }

    @Override
    public void addMove(MoveScope moveScope) {
        ++this.selectedCount;
        if (moveScope.getAcceptChance() > 0.0) {
            this.checkPickEarly(moveScope);
            this.addMoveScopeToAcceptedList(moveScope);
        }
    }

    protected void checkPickEarly(MoveScope moveScope) {
        switch (this.pickEarlyType) {
            case NEVER: {
                break;
            }
            case FIRST_BEST_SCORE_IMPROVING: {
                if (moveScope.getLocalSearchStepScope().getDeciderScoreComparator().compare(moveScope.getScore(), moveScope.getLocalSearchStepScope().getLocalSearchSolverScope().getBestScore()) <= 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            case FIRST_LAST_STEP_SCORE_IMPROVING: {
                if (moveScope.getLocalSearchStepScope().getDeciderScoreComparator().compare(moveScope.getScore(), moveScope.getLocalSearchStepScope().getLocalSearchSolverScope().getLastCompletedLocalSearchStepScope().getScore()) <= 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            default: {
                throw new IllegalStateException("The pickEarlyType (" + (Object)((Object)this.pickEarlyType) + ") is not implemented");
            }
        }
    }

    protected void addMoveScopeToAcceptedList(MoveScope moveScope) {
        this.acceptedList.add(moveScope);
        this.listSorted = false;
        if (moveScope.getLocalSearchStepScope().getDeciderScoreComparator().compare(moveScope.getScore(), this.maxScore) > 0) {
            this.acceptChanceMaxScoreTotal = moveScope.getAcceptChance();
            this.maxScore = moveScope.getScore();
        } else if (moveScope.getScore().equals(this.maxScore)) {
            this.acceptChanceMaxScoreTotal += moveScope.getAcceptChance();
        }
    }

    @Override
    public boolean isQuitEarly() {
        return this.earlyPickedMoveScope != null || this.acceptedList.size() >= this.minimalAcceptedSelection;
    }

    @Override
    public MoveScope pickMove(LocalSearchStepScope localSearchStepScope) {
        if (this.earlyPickedMoveScope != null) {
            return this.earlyPickedMoveScope;
        }
        return this.pickMaxScoreMoveScopeFromAcceptedList(localSearchStepScope);
    }

    protected MoveScope pickMaxScoreMoveScopeFromAcceptedList(LocalSearchStepScope localSearchStepScope) {
        if (this.acceptedList.isEmpty()) {
            return null;
        }
        this.sortAcceptedList();
        MoveScope pickedMoveScope = null;
        double randomChance = localSearchStepScope.getWorkingRandom().nextDouble();
        double acceptMark = this.acceptChanceMaxScoreTotal * randomChance;
        ListIterator<MoveScope> it = this.acceptedList.listIterator(this.acceptedList.size());
        while (it.hasPrevious()) {
            MoveScope moveScope = it.previous();
            if (!((acceptMark -= moveScope.getAcceptChance()) < 0.0)) continue;
            pickedMoveScope = moveScope;
            break;
        }
        if (pickedMoveScope == null) {
            this.logger.warn("Underflow occurred with acceptChanceMaxScoreTotal ({}) and randomChance ({}).", (Object)this.acceptChanceMaxScoreTotal, (Object)randomChance);
            pickedMoveScope = this.acceptedList.get(this.acceptedList.size() - 1);
        }
        return pickedMoveScope;
    }

    @Override
    public int getAcceptedMovesSize() {
        return this.acceptedList.size();
    }

    @Override
    public List<Move> getTopList(int topSize) {
        this.sortAcceptedList();
        int size = this.acceptedList.size();
        ArrayList<Move> topList = new ArrayList<Move>(Math.min(topSize, size));
        List<MoveScope> subAcceptedList = this.acceptedList.subList(Math.max(0, size - topSize), size);
        for (MoveScope moveScope : subAcceptedList) {
            topList.add(moveScope.getMove());
        }
        return topList;
    }

    protected void sortAcceptedList() {
        if (!this.listSorted) {
            Collections.sort(this.acceptedList, this.acceptedMoveScopeComparator);
            this.listSorted = true;
        }
    }
}

