/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.termination;

import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.termination.AbstractCompositeTermination;
import org.drools.planner.core.localsearch.termination.Termination;

public class AndCompositeTermination
extends AbstractCompositeTermination {
    public boolean isTerminated(LocalSearchStepScope localSearchStepScope) {
        for (Termination termination : this.terminationList) {
            if (termination.isTerminated(localSearchStepScope)) continue;
            return false;
        }
        return true;
    }

    public double calculateTimeGradient(LocalSearchStepScope localSearchStepScope) {
        double timeGradient = 1.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculateTimeGradient(localSearchStepScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.min(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }
}

