/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.termination;

import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.termination.AbstractTermination;

public class StepCountTermination
extends AbstractTermination {
    private int maximumStepCount = 100;

    public void setMaximumStepCount(int maximumStepCount) {
        this.maximumStepCount = maximumStepCount;
        if (maximumStepCount < 0) {
            throw new IllegalArgumentException("Property maximumStepCount (" + maximumStepCount + ") must be greater or equal to 0.");
        }
    }

    public boolean isTerminated(LocalSearchStepScope localSearchStepScope) {
        int stepIndex = localSearchStepScope.getStepIndex();
        return stepIndex >= this.maximumStepCount;
    }

    public double calculateTimeGradient(LocalSearchStepScope localSearchStepScope) {
        int stepIndex = localSearchStepScope.getStepIndex();
        double timeGradient = (double)stepIndex / (double)this.maximumStepCount;
        return Math.min(timeGradient, 1.0);
    }
}

