/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.solver;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.RuleBase;
import org.drools.planner.core.Solver;
import org.drools.planner.core.bestsolution.BestSolutionRecaller;
import org.drools.planner.core.event.SolverEventListener;
import org.drools.planner.core.event.SolverEventSupport;
import org.drools.planner.core.score.calculator.ScoreCalculator;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solution.initializer.StartingSolutionInitializer;
import org.drools.planner.core.solver.AbstractSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolver
implements Solver {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolverEventSupport solverEventSupport = new SolverEventSupport(this);
    protected final AtomicBoolean terminatedEarly = new AtomicBoolean(false);
    protected Long randomSeed;
    protected StartingSolutionInitializer startingSolutionInitializer = null;
    protected BestSolutionRecaller bestSolutionRecaller;

    public void setRandomSeed(long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.getAbstractSolverScope().setRuleBase(ruleBase);
    }

    public ScoreDefinition getScoreDefinition() {
        return this.getAbstractSolverScope().getScoreDefinition();
    }

    public void setScoreDefinition(ScoreDefinition scoreDefinition) {
        this.getAbstractSolverScope().setScoreDefinition(scoreDefinition);
    }

    public void setScoreCalculator(ScoreCalculator scoreCalculator) {
        this.getAbstractSolverScope().setWorkingScoreCalculator(scoreCalculator);
    }

    public StartingSolutionInitializer getStartingSolutionInitializer() {
        return this.startingSolutionInitializer;
    }

    public void setStartingSolutionInitializer(StartingSolutionInitializer startingSolutionInitializer) {
        this.startingSolutionInitializer = startingSolutionInitializer;
    }

    public void setBestSolutionRecaller(BestSolutionRecaller bestSolutionRecaller) {
        this.bestSolutionRecaller = bestSolutionRecaller;
        this.bestSolutionRecaller.setSolverEventSupport(this.solverEventSupport);
    }

    public void setStartingSolution(Solution startingSolution) {
        this.getAbstractSolverScope().setWorkingSolution(startingSolution);
    }

    public Solution getBestSolution() {
        return this.getAbstractSolverScope().getBestSolution();
    }

    public long getTimeMillisSpend() {
        return this.getAbstractSolverScope().calculateTimeMillisSpend();
    }

    public abstract AbstractSolverScope getAbstractSolverScope();

    public boolean terminateEarly() {
        boolean terminationEarlySuccessful;
        boolean bl = terminationEarlySuccessful = !this.terminatedEarly.getAndSet(true);
        if (terminationEarlySuccessful) {
            this.logger.info("Terminating solver early.");
        }
        return terminationEarlySuccessful;
    }

    public boolean isTerminatedEarly() {
        return this.terminatedEarly.get();
    }

    public final void solve() {
        this.terminatedEarly.set(false);
        this.solveImplementation();
    }

    protected abstract void solveImplementation();

    public void solvingStarted(AbstractSolverScope abstractSolverScope) {
        if (abstractSolverScope.getWorkingSolution() == null) {
            throw new IllegalStateException("The startingSolution must not be null. Use Solver.setStartingSolution(Solution).");
        }
        abstractSolverScope.reset();
        if (this.randomSeed != null) {
            this.logger.info("Solving with random seed ({}).", (Object)this.randomSeed);
            abstractSolverScope.setWorkingRandom(new Random(this.randomSeed));
        } else {
            this.logger.info("Solving with a non-fixed random seed.");
            abstractSolverScope.setWorkingRandom(new Random());
        }
        if (this.startingSolutionInitializer != null) {
            if (!this.startingSolutionInitializer.isSolutionInitialized(abstractSolverScope)) {
                this.logger.info("Initializing solution.");
                this.startingSolutionInitializer.initializeSolution(abstractSolverScope);
            } else {
                this.logger.debug("Solution is already initialized.");
            }
        }
        this.bestSolutionRecaller.solvingStarted(abstractSolverScope);
        this.logger.info("Starting with time spend ({}), score ({}), new best score ({}).", new Object[]{abstractSolverScope.calculateTimeMillisSpend(), abstractSolverScope.getStartingScore(), abstractSolverScope.getBestScore()});
    }

    public void addEventListener(SolverEventListener eventListener) {
        this.solverEventSupport.addEventListener(eventListener);
    }

    public void removeEventListener(SolverEventListener eventListener) {
        this.solverEventSupport.removeEventListener(eventListener);
    }
}

