/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.forager;

import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.forager.AcceptedForager;
import org.drools.planner.core.localsearch.decider.forager.PickEarlyType;
import org.drools.planner.core.move.DummyMove;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.DefaultSimpleScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.comparator.NaturalScoreComparator;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.score.definition.SimpleScoreDefinition;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AcceptedForagerTest {
    @Test
    public void testPickMoveMaxScoreOfAll() {
        AcceptedForager forager = new AcceptedForager(PickEarlyType.NEVER, Integer.MAX_VALUE);
        LocalSearchSolverScope localSearchSolverScope = this.createLocalSearchSolverScope();
        forager.solvingStarted(localSearchSolverScope);
        LocalSearchStepScope localSearchStepScope = this.createStepScope(localSearchSolverScope);
        forager.beforeDeciding(localSearchStepScope);
        MoveScope a = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-20), 30.0);
        MoveScope b = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 9.0);
        MoveScope c = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-20), 20.0);
        MoveScope d = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-300), 50000.0);
        MoveScope e = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 1.0);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(e);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        MoveScope pickedScope = forager.pickMove(localSearchStepScope);
        Assert.assertSame((Object)b, (Object)pickedScope);
        List topList = forager.getTopList(3);
        Assert.assertTrue((boolean)topList.contains(a.getMove()));
        Assert.assertTrue((boolean)topList.contains(b.getMove()));
        Assert.assertFalse((boolean)topList.contains(c.getMove()));
        Assert.assertFalse((boolean)topList.contains(d.getMove()));
        Assert.assertTrue((boolean)topList.contains(e.getMove()));
        forager.solvingEnded(localSearchSolverScope);
    }

    @Test
    public void testPickMoveFirstBestScoreImproving() {
        AcceptedForager forager = new AcceptedForager(PickEarlyType.FIRST_BEST_SCORE_IMPROVING, Integer.MAX_VALUE);
        LocalSearchSolverScope localSearchSolverScope = this.createLocalSearchSolverScope();
        forager.solvingStarted(localSearchSolverScope);
        LocalSearchStepScope localSearchStepScope = this.createStepScope(localSearchSolverScope);
        forager.beforeDeciding(localSearchStepScope);
        MoveScope a = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 0.0);
        MoveScope b = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-20), 1.0);
        MoveScope c = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-300), 1.0);
        MoveScope d = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 0.3);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertTrue((boolean)forager.isQuitEarly());
        MoveScope pickedScope = forager.pickMove(localSearchStepScope);
        Assert.assertSame((Object)d, (Object)pickedScope);
        List topList = forager.getTopList(2);
        Assert.assertTrue((boolean)topList.contains(b.getMove()));
        Assert.assertTrue((boolean)topList.contains(d.getMove()));
        forager.solvingEnded(localSearchSolverScope);
    }

    @Test
    public void testPickMoveFirstLastStepScoreImproving() {
        AcceptedForager forager = new AcceptedForager(PickEarlyType.FIRST_LAST_STEP_SCORE_IMPROVING, Integer.MAX_VALUE);
        LocalSearchSolverScope localSearchSolverScope = this.createLocalSearchSolverScope();
        forager.solvingStarted(localSearchSolverScope);
        LocalSearchStepScope localSearchStepScope = this.createStepScope(localSearchSolverScope);
        forager.beforeDeciding(localSearchStepScope);
        MoveScope a = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 0.0);
        MoveScope b = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-300), 1.0);
        MoveScope c = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-4000), 1.0);
        MoveScope d = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-20), 0.3);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertTrue((boolean)forager.isQuitEarly());
        MoveScope pickedScope = forager.pickMove(localSearchStepScope);
        Assert.assertSame((Object)d, (Object)pickedScope);
        List topList = forager.getTopList(2);
        Assert.assertTrue((boolean)topList.contains(b.getMove()));
        Assert.assertTrue((boolean)topList.contains(d.getMove()));
        forager.solvingEnded(localSearchSolverScope);
    }

    @Test
    @Ignore
    public void testPickMoveRandomly() {
        AcceptedForager forager = new AcceptedForager(PickEarlyType.NEVER, 1);
        LocalSearchSolverScope localSearchSolverScope = this.createLocalSearchSolverScope();
        forager.solvingStarted(localSearchSolverScope);
        LocalSearchStepScope localSearchStepScope = this.createStepScope(localSearchSolverScope);
        forager.beforeDeciding(localSearchStepScope);
        MoveScope a = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-20), 0.0);
        MoveScope b = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 0.1);
        MoveScope c = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-1), 0.0);
        MoveScope d = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-20), 0.3);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertTrue((boolean)forager.isQuitEarly());
        MoveScope pickedScope = forager.pickMove(localSearchStepScope);
        Assert.assertSame((Object)d, (Object)pickedScope);
        List topList = forager.getTopList(2);
        Assert.assertTrue((boolean)topList.contains(b.getMove()));
        Assert.assertTrue((boolean)topList.contains(d.getMove()));
        forager.solvingEnded(localSearchSolverScope);
    }

    private LocalSearchSolverScope createLocalSearchSolverScope() {
        LocalSearchSolverScope localSearchSolverScope = new LocalSearchSolverScope();
        localSearchSolverScope.setScoreDefinition((ScoreDefinition)new SimpleScoreDefinition());
        localSearchSolverScope.setWorkingRandom(new Random(){

            public double nextDouble() {
                return 0.2;
            }
        });
        localSearchSolverScope.setBestScore((Score)DefaultSimpleScore.valueOf((int)-10));
        LocalSearchStepScope lastLocalSearchStepScope = new LocalSearchStepScope(localSearchSolverScope);
        lastLocalSearchStepScope.setScore((Score)DefaultSimpleScore.valueOf((int)-100));
        localSearchSolverScope.setLastCompletedLocalSearchStepScope(lastLocalSearchStepScope);
        return localSearchSolverScope;
    }

    private LocalSearchStepScope createStepScope(LocalSearchSolverScope localSearchSolverScope) {
        LocalSearchStepScope localSearchStepScope = new LocalSearchStepScope(localSearchSolverScope);
        localSearchStepScope.setDeciderScoreComparator((Comparator)new NaturalScoreComparator());
        return localSearchStepScope;
    }

    public MoveScope createMoveScope(LocalSearchStepScope localSearchStepScope, Score score, double acceptChance) {
        MoveScope moveScope = new MoveScope(localSearchStepScope);
        moveScope.setMove((Move)new DummyMove());
        moveScope.setScore(score);
        moveScope.setAcceptChance(acceptChance);
        return moveScope;
    }
}

