/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.score.definition.ScoreDefinitionConfig;
import org.drools.planner.core.Solver;
import org.drools.planner.core.bestsolution.BestSolutionRecaller;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.initializer.StartingSolutionInitializer;
import org.drools.planner.core.solver.AbstractSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSolverConfig {
    protected static final long DEFAULT_RANDOM_SEED = 0L;
    protected EnvironmentMode environmentMode = null;
    protected Long randomSeed = null;
    @XStreamOmitField
    protected RuleBase ruleBase = null;
    @XStreamImplicit(itemFieldName="scoreDrl")
    protected List<String> scoreDrlList = null;
    @XStreamAlias(value="scoreDefinition")
    protected ScoreDefinitionConfig scoreDefinitionConfig = new ScoreDefinitionConfig();
    protected StartingSolutionInitializer startingSolutionInitializer = null;
    protected Class<StartingSolutionInitializer> startingSolutionInitializerClass = null;

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public Long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public List<String> getScoreDrlList() {
        return this.scoreDrlList;
    }

    public void setScoreDrlList(List<String> scoreDrlList) {
        this.scoreDrlList = scoreDrlList;
    }

    public ScoreDefinitionConfig getScoreDefinitionConfig() {
        return this.scoreDefinitionConfig;
    }

    public void setScoreDefinitionConfig(ScoreDefinitionConfig scoreDefinitionConfig) {
        this.scoreDefinitionConfig = scoreDefinitionConfig;
    }

    public StartingSolutionInitializer getStartingSolutionInitializer() {
        return this.startingSolutionInitializer;
    }

    public void setStartingSolutionInitializer(StartingSolutionInitializer startingSolutionInitializer) {
        this.startingSolutionInitializer = startingSolutionInitializer;
    }

    public Class<StartingSolutionInitializer> getStartingSolutionInitializerClass() {
        return this.startingSolutionInitializerClass;
    }

    public void setStartingSolutionInitializerClass(Class<StartingSolutionInitializer> startingSolutionInitializerClass) {
        this.startingSolutionInitializerClass = startingSolutionInitializerClass;
    }

    public abstract Solver buildSolver();

    protected ScoreDefinition configureAbstractSolver(AbstractSolver abstractSolver) {
        if (this.environmentMode != EnvironmentMode.PRODUCTION) {
            if (this.randomSeed != null) {
                abstractSolver.setRandomSeed(this.randomSeed);
            } else {
                abstractSolver.setRandomSeed(0L);
            }
        }
        abstractSolver.setRuleBase(this.buildRuleBase());
        ScoreDefinition scoreDefinition = this.scoreDefinitionConfig.buildScoreDefinition();
        abstractSolver.setScoreDefinition(scoreDefinition);
        abstractSolver.setScoreCalculator(this.scoreDefinitionConfig.buildScoreCalculator());
        abstractSolver.setStartingSolutionInitializer(this.buildStartingSolutionInitializer());
        abstractSolver.setBestSolutionRecaller(new BestSolutionRecaller());
        return scoreDefinition;
    }

    private RuleBase buildRuleBase() {
        if (this.ruleBase != null) {
            if (this.scoreDrlList != null && !this.scoreDrlList.isEmpty()) {
                throw new IllegalArgumentException("If ruleBase is not null, the scoreDrlList (" + this.scoreDrlList + ") must be empty.");
            }
            return this.ruleBase;
        }
        PackageBuilder packageBuilder = new PackageBuilder();
        for (String scoreDrl : this.scoreDrlList) {
            InputStream scoreDrlIn = this.getClass().getResourceAsStream(scoreDrl);
            if (scoreDrlIn == null) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") does not exist as a classpath resource.");
            }
            try {
                packageBuilder.addPackageFromDrl((Reader)new InputStreamReader(scoreDrlIn, "utf-8"));
            }
            catch (DroolsParserException e) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") could not be loaded.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") could not be loaded.", e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)scoreDrlIn);
            }
        }
        RuleBaseConfiguration ruleBaseConfiguration = new RuleBaseConfiguration();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)ruleBaseConfiguration);
        if (packageBuilder.hasErrors()) {
            throw new IllegalStateException("There are errors in the scoreDrl's:" + packageBuilder.getErrors().toString());
        }
        ruleBase.addPackage(packageBuilder.getPackage());
        return ruleBase;
    }

    public StartingSolutionInitializer buildStartingSolutionInitializer() {
        if (this.startingSolutionInitializer != null) {
            return this.startingSolutionInitializer;
        }
        if (this.startingSolutionInitializerClass != null) {
            try {
                return this.startingSolutionInitializerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("startingSolutionInitializerClass (" + this.startingSolutionInitializerClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("startingSolutionInitializerClass (" + this.startingSolutionInitializerClass.getName() + ") does not have a public no-arg constructor", e);
            }
        }
        return null;
    }

    public void inherit(AbstractSolverConfig inheritedConfig) {
        if (this.environmentMode == null) {
            this.environmentMode = inheritedConfig.getEnvironmentMode();
        }
        if (this.randomSeed == null) {
            this.randomSeed = inheritedConfig.getRandomSeed();
        }
        if (this.scoreDrlList == null) {
            this.scoreDrlList = inheritedConfig.getScoreDrlList();
        } else {
            List<String> inheritedScoreDrlList = inheritedConfig.getScoreDrlList();
            if (inheritedScoreDrlList != null) {
                for (String inheritedScoreDrl : inheritedScoreDrlList) {
                    if (this.scoreDrlList.contains(inheritedScoreDrl)) continue;
                    this.scoreDrlList.add(inheritedScoreDrl);
                }
            }
        }
        if (this.scoreDefinitionConfig == null) {
            this.scoreDefinitionConfig = inheritedConfig.getScoreDefinitionConfig();
        } else if (inheritedConfig.getScoreDefinitionConfig() != null) {
            this.scoreDefinitionConfig.inherit(inheritedConfig.getScoreDefinitionConfig());
        }
        if (this.startingSolutionInitializer == null && this.startingSolutionInitializerClass == null) {
            this.startingSolutionInitializer = inheritedConfig.getStartingSolutionInitializer();
            this.startingSolutionInitializerClass = inheritedConfig.getStartingSolutionInitializerClass();
        }
    }
}

