/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.bruteforce;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.annotations.PlanningValueProperty;
import org.drools.planner.core.annotations.PlanningVariableClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningVariableHandler {
    private Object planningVariable;
    private final PlanningVariableClass planningVariableClass;
    private Method valueMethod;
    private List<Object> planningValueList;
    private Iterator<Object> planningValueListIterator;

    public PlanningVariableHandler(Object planningVariable, PlanningVariableClass planningVariableClass, Collection<? extends Object> facts) {
        this.planningVariable = planningVariable;
        this.planningVariableClass = planningVariableClass;
        for (Method method : planningVariable.getClass().getMethods()) {
            PlanningValueProperty planningValueProperty = method.getAnnotation(PlanningValueProperty.class);
            if (planningValueProperty == null) continue;
            this.valueMethod = method;
            Class<?> planningValueClass = this.valueMethod.getParameterTypes()[0];
            this.planningValueList = new ArrayList<Object>();
            for (Object object : facts) {
                if (!planningValueClass.isInstance(object)) continue;
                this.planningValueList.add(object);
            }
            this.planningValueListIterator = this.planningValueList.iterator();
            break;
        }
    }

    public boolean hasNext() {
        return this.planningValueListIterator.hasNext();
    }

    public void next(WorkingMemory workingMemory) {
        Object value = this.planningValueListIterator.next();
        this.doValue(workingMemory, value);
    }

    public void reset(WorkingMemory workingMemory) {
        this.planningValueListIterator = this.planningValueList.iterator();
        Object value = this.planningValueListIterator.next();
        this.doValue(workingMemory, value);
    }

    private void doValue(WorkingMemory workingMemory, Object value) {
        FactHandle factHandle = workingMemory.getFactHandle(this.planningVariable);
        try {
            this.valueMethod.invoke(this.planningVariable, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not call method to set planningValue", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Could not call method to set planningValue", e);
        }
        workingMemory.update((org.drools.runtime.rule.FactHandle)factHandle, this.planningVariable);
    }
}

