/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.solver;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.drools.ClassObjectFilter;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.calculator.ScoreCalculator;
import org.drools.planner.core.score.constraint.ConstraintOccurrence;
import org.drools.planner.core.score.constraint.DoubleConstraintOccurrence;
import org.drools.planner.core.score.constraint.IntConstraintOccurrence;
import org.drools.planner.core.score.constraint.UnweightedConstraintOccurrence;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.drools.runtime.ObjectFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolverScope {
    public static final String GLOBAL_SCORE_CALCULATOR_KEY = "scoreCalculator";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected RuleBase ruleBase;
    protected ScoreDefinition scoreDefinition;
    protected long startingSystemTimeMillis;
    protected Solution workingSolution;
    protected StatefulSession workingMemory;
    protected ScoreCalculator workingScoreCalculator;
    protected Random workingRandom;
    protected Score startingScore;
    protected long calculateCount;
    protected int bestSolutionStepIndex;
    protected Solution bestSolution;
    protected Score bestScore;

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDefinition;
    }

    public void setScoreDefinition(ScoreDefinition scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
    }

    public long getStartingSystemTimeMillis() {
        return this.startingSystemTimeMillis;
    }

    public void setStartingSystemTimeMillis(long startingSystemTimeMillis) {
        this.startingSystemTimeMillis = startingSystemTimeMillis;
    }

    public Solution getWorkingSolution() {
        return this.workingSolution;
    }

    public void setWorkingSolution(Solution workingSolution) {
        this.workingSolution = workingSolution;
        this.resetWorkingMemory();
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public ScoreCalculator getWorkingScoreCalculator() {
        return this.workingScoreCalculator;
    }

    public void setWorkingScoreCalculator(ScoreCalculator workingScoreCalculator) {
        this.workingScoreCalculator = workingScoreCalculator;
    }

    public Random getWorkingRandom() {
        return this.workingRandom;
    }

    public void setWorkingRandom(Random workingRandom) {
        this.workingRandom = workingRandom;
    }

    public Score getStartingScore() {
        return this.startingScore;
    }

    public void setStartingScore(Score startingScore) {
        this.startingScore = startingScore;
    }

    public long getCalculateCount() {
        return this.calculateCount;
    }

    public int getBestSolutionStepIndex() {
        return this.bestSolutionStepIndex;
    }

    public void setBestSolutionStepIndex(int bestSolutionStepIndex) {
        this.bestSolutionStepIndex = bestSolutionStepIndex;
    }

    public Solution getBestSolution() {
        return this.bestSolution;
    }

    public void setBestSolution(Solution bestSolution) {
        this.bestSolution = bestSolution;
    }

    public Score getBestScore() {
        return this.bestScore;
    }

    public void setBestScore(Score bestScore) {
        this.bestScore = bestScore;
    }

    public void reset() {
        this.startingSystemTimeMillis = System.currentTimeMillis();
        this.calculateCount = 0L;
    }

    public Score calculateScoreFromWorkingMemory() {
        this.workingMemory.fireAllRules();
        Score score = this.workingScoreCalculator.calculateScore();
        this.workingSolution.setScore(score);
        ++this.calculateCount;
        return score;
    }

    public long calculateTimeMillisSpend() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }

    private void resetWorkingMemory() {
        if (this.workingMemory != null) {
            this.workingMemory.dispose();
        }
        this.workingMemory = this.ruleBase.newStatefulSession();
        this.workingMemory.setGlobal(GLOBAL_SCORE_CALCULATOR_KEY, (Object)this.workingScoreCalculator);
        for (Object fact : this.workingSolution.getFacts()) {
            this.workingMemory.insert(fact);
        }
    }

    public void assertWorkingScore(Score presumedScore) {
        StatefulSession tmpWorkingMemory = this.ruleBase.newStatefulSession();
        ScoreCalculator tmpScoreCalculator = this.workingScoreCalculator.clone();
        tmpWorkingMemory.setGlobal(GLOBAL_SCORE_CALCULATOR_KEY, (Object)tmpScoreCalculator);
        for (Object fact : this.workingSolution.getFacts()) {
            tmpWorkingMemory.insert(fact);
        }
        tmpWorkingMemory.fireAllRules();
        Score realScore = tmpScoreCalculator.calculateScore();
        tmpWorkingMemory.dispose();
        if (!presumedScore.equals(realScore)) {
            throw new IllegalStateException("The presumedScore (" + presumedScore + ") is corrupted because it is not the realScore  (" + realScore + ").\n" + "Presumed workingMemory:\n" + this.buildConstraintOccurrenceSummary((WorkingMemory)this.workingMemory) + "Real workingMemory:\n" + this.buildConstraintOccurrenceSummary((WorkingMemory)tmpWorkingMemory));
        }
    }

    public String buildConstraintOccurrenceSummary() {
        return this.buildConstraintOccurrenceSummary((WorkingMemory)this.workingMemory);
    }

    public String buildConstraintOccurrenceSummary(WorkingMemory summaryWorkingMemory) {
        this.logger.trace("Building ConstraintOccurrence summary");
        if (summaryWorkingMemory == null) {
            return "  The workingMemory is null.";
        }
        TreeMap<String, SummaryLine> summaryLineMap = new TreeMap<String, SummaryLine>();
        Iterator it = summaryWorkingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(ConstraintOccurrence.class));
        while (it.hasNext()) {
            ConstraintOccurrence occurrence = (ConstraintOccurrence)it.next();
            this.logger.trace("Adding ConstraintOccurrence ({})", (Object)occurrence);
            SummaryLine summaryLine = (SummaryLine)summaryLineMap.get(occurrence.getRuleId());
            if (summaryLine == null) {
                summaryLine = new SummaryLine();
                summaryLineMap.put(occurrence.getRuleId(), summaryLine);
            }
            summaryLine.increment();
            if (occurrence instanceof IntConstraintOccurrence) {
                summaryLine.addWeight(((IntConstraintOccurrence)occurrence).getWeight());
                continue;
            }
            if (occurrence instanceof DoubleConstraintOccurrence) {
                summaryLine.addWeight(((DoubleConstraintOccurrence)occurrence).getWeight());
                continue;
            }
            if (occurrence instanceof UnweightedConstraintOccurrence) {
                summaryLine.addWeight(1);
                continue;
            }
            throw new IllegalStateException("Cannot determine occurrenceScore of ConstraintOccurrence class: " + occurrence.getClass());
        }
        StringBuilder summary = new StringBuilder();
        for (Map.Entry summaryLineEntry : summaryLineMap.entrySet()) {
            SummaryLine summaryLine = (SummaryLine)summaryLineEntry.getValue();
            summary.append("  Score rule (").append((String)summaryLineEntry.getKey()).append(") has count (").append(summaryLine.getCount()).append(") and weight total (").append(summaryLine.getWeightTotal()).append(").\n");
        }
        return summary.toString();
    }

    private class SummaryLine {
        private int count = 0;
        private Number weightTotal = null;

        private SummaryLine() {
        }

        public int getCount() {
            return this.count;
        }

        public Number getWeightTotal() {
            return this.weightTotal;
        }

        public void increment() {
            ++this.count;
        }

        public void addWeight(Integer weight) {
            if (this.weightTotal == null) {
                this.weightTotal = 0;
            }
            this.weightTotal = (Integer)this.weightTotal + weight;
        }

        public void addWeight(Double weight) {
            if (this.weightTotal == null) {
                this.weightTotal = 0.0;
            }
            this.weightTotal = (Double)this.weightTotal + weight;
        }
    }
}

