/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.greatdeluge;

import java.util.Random;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.greatdeluge.GreatDelugeAcceptor;
import org.drools.planner.core.move.DummyMove;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.DefaultSimpleScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.score.definition.SimpleScoreDefinition;
import org.drools.planner.core.solution.director.DefaultSolutionDirector;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.junit.Assert;
import org.junit.Test;

public class GreatDelugeAcceptorTest {
    @Test
    public void testCalculateAcceptChance() {
        GreatDelugeAcceptor acceptor = new GreatDelugeAcceptor(1.2, 0.01);
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = this.createLocalSearchSolverPhaseScope();
        acceptor.phaseStarted(localSearchSolverPhaseScope);
        LocalSearchStepScope localSearchStepScope = new LocalSearchStepScope(localSearchSolverPhaseScope);
        localSearchStepScope.setStepIndex(0);
        acceptor.beforeDeciding(localSearchStepScope);
        MoveScope a1 = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-2000));
        MoveScope a2 = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-1300));
        MoveScope a3 = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-1200));
        MoveScope b1 = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-1200));
        MoveScope b2 = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-100));
        MoveScope c1 = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-1100));
        MoveScope c2 = this.createMoveScope(localSearchStepScope, (Score)DefaultSimpleScore.valueOf((int)-120));
        Assert.assertEquals((double)0.0, (double)acceptor.calculateAcceptChance(a1), (double)0.0);
        Assert.assertEquals((double)0.0, (double)acceptor.calculateAcceptChance(a2), (double)0.0);
        Assert.assertEquals((double)1.0, (double)acceptor.calculateAcceptChance(a3), (double)0.0);
    }

    private LocalSearchSolverPhaseScope createLocalSearchSolverPhaseScope() {
        DefaultSolverScope solverScope = new DefaultSolverScope();
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = new LocalSearchSolverPhaseScope(solverScope);
        DefaultSolutionDirector solutionDirector = new DefaultSolutionDirector();
        solutionDirector.setScoreDefinition((ScoreDefinition)new SimpleScoreDefinition());
        solverScope.setSolutionDirector(solutionDirector);
        solverScope.setWorkingRandom(new Random(){

            public double nextDouble() {
                return 0.2;
            }
        });
        solverScope.setBestScore((Score)DefaultSimpleScore.valueOf((int)-1000));
        LocalSearchStepScope lastLocalSearchStepScope = new LocalSearchStepScope(localSearchSolverPhaseScope);
        lastLocalSearchStepScope.setScore((Score)DefaultSimpleScore.valueOf((int)-1000));
        localSearchSolverPhaseScope.setLastCompletedLocalSearchStepScope(lastLocalSearchStepScope);
        return localSearchSolverPhaseScope;
    }

    public MoveScope createMoveScope(LocalSearchStepScope localSearchStepScope, Score score) {
        MoveScope moveScope = new MoveScope(localSearchStepScope);
        moveScope.setMove((Move)new DummyMove());
        moveScope.setScore(score);
        return moveScope;
    }
}

