/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.drools.planner.benchmark.SolverBenchmarkResult;
import org.drools.planner.config.solver.SolverConfig;
import org.drools.planner.core.score.Score;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="solverBenchmark")
public class SolverBenchmark {
    private String name = null;
    @XStreamAlias(value="solver")
    private SolverConfig solverConfig = null;
    @XStreamImplicit(itemFieldName="unsolvedSolutionFile")
    private List<File> unsolvedSolutionFileList = null;
    @XStreamImplicit(itemFieldName="solverBenchmarkResult")
    private List<SolverBenchmarkResult> solverBenchmarkResultList = null;
    private Integer ranking = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SolverConfig getSolverConfig() {
        return this.solverConfig;
    }

    public void setSolverConfig(SolverConfig solverConfig) {
        this.solverConfig = solverConfig;
    }

    public List<File> getUnsolvedSolutionFileList() {
        return this.unsolvedSolutionFileList;
    }

    public void setUnsolvedSolutionFileList(List<File> unsolvedSolutionFileList) {
        this.unsolvedSolutionFileList = unsolvedSolutionFileList;
    }

    public List<SolverBenchmarkResult> getSolverBenchmarkResultList() {
        return this.solverBenchmarkResultList;
    }

    public void setSolverBenchmarkResultList(List<SolverBenchmarkResult> solverBenchmarkResultList) {
        this.solverBenchmarkResultList = solverBenchmarkResultList;
    }

    public Integer getRanking() {
        return this.ranking;
    }

    public void setRanking(Integer ranking) {
        this.ranking = ranking;
    }

    public void inherit(SolverBenchmark inheritedSolverBenchmark) {
        if (this.solverConfig == null) {
            this.solverConfig = inheritedSolverBenchmark.getSolverConfig();
        } else if (inheritedSolverBenchmark.getSolverConfig() != null) {
            this.solverConfig.inherit(inheritedSolverBenchmark.getSolverConfig());
        }
        if (this.unsolvedSolutionFileList == null) {
            this.unsolvedSolutionFileList = inheritedSolverBenchmark.getUnsolvedSolutionFileList();
        } else if (inheritedSolverBenchmark.getUnsolvedSolutionFileList() != null) {
            ArrayList<File> mergedList = new ArrayList<File>(inheritedSolverBenchmark.getUnsolvedSolutionFileList());
            for (File unsolvedSolutionFile : this.unsolvedSolutionFileList) {
                if (mergedList.contains(unsolvedSolutionFile)) continue;
                mergedList.add(unsolvedSolutionFile);
            }
            this.unsolvedSolutionFileList = mergedList;
        }
    }

    public void resetSolverBenchmarkResultList() {
        this.solverBenchmarkResultList = new ArrayList<SolverBenchmarkResult>();
        for (File unsolvedSolutionFile : this.unsolvedSolutionFileList) {
            SolverBenchmarkResult result = new SolverBenchmarkResult();
            result.setUnsolvedSolutionFile(unsolvedSolutionFile);
            this.solverBenchmarkResultList.add(result);
        }
    }

    public List<Score> getScoreList() {
        ArrayList<Score> scoreList = new ArrayList<Score>(this.solverBenchmarkResultList.size());
        for (SolverBenchmarkResult solverBenchmarkResult : this.solverBenchmarkResultList) {
            scoreList.add(solverBenchmarkResult.getScore());
        }
        return scoreList;
    }

    public Score getTotalScore() {
        Score totalScore = null;
        for (SolverBenchmarkResult solverBenchmarkResult : this.solverBenchmarkResultList) {
            if (totalScore == null) {
                totalScore = solverBenchmarkResult.getScore();
                continue;
            }
            totalScore = totalScore.add(solverBenchmarkResult.getScore());
        }
        return totalScore;
    }

    public Score getAverageScore() {
        return this.getTotalScore().divide(this.solverBenchmarkResultList.size());
    }

    public void validate() {
        if (this.unsolvedSolutionFileList == null || this.unsolvedSolutionFileList.isEmpty()) {
            throw new IllegalArgumentException("Configure at least 1 <unsolvedSolutionFile> for the <solverBenchmark> (" + this.name + ") directly or indirectly by inheriting it.");
        }
    }
}

