/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.statistic;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class MillisecondsSpendNumberFormat
extends NumberFormat {
    private static final long DAY_MILLIS = 86400000L;
    private static final long HOUR_MILLIS = 3600000L;
    private static final long MINUTE_MILLIS = 60000L;
    private static final long SECOND_MILLIS = 1000L;

    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((long)number, toAppendTo, pos);
    }

    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        long seconds;
        long minutes;
        long hours;
        long rest;
        long days;
        if (number == 0L) {
            toAppendTo.append("0");
        }
        if ((days = (rest = number) / 86400000L) > 0L) {
            toAppendTo.append(days).append("d");
            rest %= 86400000L;
        }
        if ((hours = rest / 3600000L) > 0L) {
            toAppendTo.append(hours).append("h");
            rest %= 3600000L;
        }
        if ((minutes = rest / 60000L) > 0L) {
            toAppendTo.append(minutes).append("m");
            rest %= 60000L;
        }
        if ((seconds = rest / 1000L) > 0L) {
            toAppendTo.append(seconds).append("s");
            rest %= 1000L;
        }
        if (rest > 0L) {
            toAppendTo.append(rest).append("ms");
        }
        return toAppendTo;
    }

    public Number parse(String source, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }
}

