/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.NativeFieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.drools.planner.config.bruteforce.BruteForceSolverPhaseConfig;
import org.drools.planner.config.constructionheuristic.ConstructionHeuristicSolverPhaseConfig;
import org.drools.planner.config.localsearch.LocalSearchSolverPhaseConfig;
import org.drools.planner.config.phase.custom.CustomSolverPhaseConfig;
import org.drools.planner.config.solver.SolverConfig;
import org.drools.planner.core.Solver;

public class XmlSolverConfigurer {
    private XStream xStream = XmlSolverConfigurer.buildXstream();
    private SolverConfig solverConfig = null;

    public static XStream buildXstream() {
        XStream xStream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(new FieldDictionary((FieldKeySorter)new NativeFieldKeySorter())));
        xStream.setMode(1002);
        xStream.processAnnotations(SolverConfig.class);
        xStream.processAnnotations(CustomSolverPhaseConfig.class);
        xStream.processAnnotations(BruteForceSolverPhaseConfig.class);
        xStream.processAnnotations(ConstructionHeuristicSolverPhaseConfig.class);
        xStream.processAnnotations(LocalSearchSolverPhaseConfig.class);
        return xStream;
    }

    public XmlSolverConfigurer() {
    }

    public XmlSolverConfigurer(String resource) {
        this();
        this.configure(resource);
    }

    public void addXstreamAlias(Class aliasClass) {
        this.xStream.processAnnotations(aliasClass);
    }

    public SolverConfig getSolverConfig() {
        return this.solverConfig;
    }

    public XmlSolverConfigurer configure(String resource) {
        InputStream in = this.getClass().getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalArgumentException("The solver configuration (" + resource + ") does not exist.");
        }
        return this.configure(in);
    }

    public XmlSolverConfigurer configure(InputStream in) {
        XmlSolverConfigurer xmlSolverConfigurer;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(in, "utf-8");
            xmlSolverConfigurer = this.configure(reader);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This vm does not support utf-8 encoding.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)in);
        return xmlSolverConfigurer;
    }

    public XmlSolverConfigurer configure(Reader reader) {
        this.solverConfig = (SolverConfig)this.xStream.fromXML(reader);
        return this;
    }

    public Solver buildSolver() {
        return this.solverConfig.buildSolver();
    }
}

