/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.constructionheuristic;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Set;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.phase.SolverPhaseConfig;
import org.drools.planner.core.constructionheuristic.greedyFit.DefaultGreedyFitSolverPhase;
import org.drools.planner.core.constructionheuristic.greedyFit.GreedyFitSolverPhase;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.ConstructionHeuristicPickEarlyType;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.DefaultGreedyDecider;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.GreedyDecider;
import org.drools.planner.core.constructionheuristic.greedyFit.selector.GreedyPlanningEntitySelector;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.entity.PlanningEntitySelectionOrder;
import org.drools.planner.core.heuristic.selector.entity.PlanningEntitySelector;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelectionOrder;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelector;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueWalker;
import org.drools.planner.core.heuristic.selector.variable.PlanningVariableWalker;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.termination.Termination;

@XStreamAlias(value="constructionHeuristic")
public class ConstructionHeuristicSolverPhaseConfig
extends SolverPhaseConfig {
    protected ConstructionHeuristicType constructionHeuristicType = null;
    protected ConstructionHeuristicPickEarlyType constructionHeuristicPickEarlyType = null;

    public ConstructionHeuristicType getConstructionHeuristicType() {
        return this.constructionHeuristicType;
    }

    public void setConstructionHeuristicType(ConstructionHeuristicType constructionHeuristicType) {
        this.constructionHeuristicType = constructionHeuristicType;
    }

    public ConstructionHeuristicPickEarlyType getConstructionHeuristicPickEarlyType() {
        return this.constructionHeuristicPickEarlyType;
    }

    public void setConstructionHeuristicPickEarlyType(ConstructionHeuristicPickEarlyType constructionHeuristicPickEarlyType) {
        this.constructionHeuristicPickEarlyType = constructionHeuristicPickEarlyType;
    }

    public GreedyFitSolverPhase buildSolverPhase(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, ScoreDefinition scoreDefinition, Termination solverTermination) {
        if (this.constructionHeuristicType != null) {
            DefaultGreedyFitSolverPhase greedySolverPhase = new DefaultGreedyFitSolverPhase();
            this.configureSolverPhase(greedySolverPhase, environmentMode, scoreDefinition, solverTermination);
            greedySolverPhase.setGreedyPlanningEntitySelector(this.buildGreedyPlanningEntitySelector(solutionDescriptor));
            greedySolverPhase.setGreedyDecider(this.buildGreedyDecider(solutionDescriptor, environmentMode));
            if (environmentMode == EnvironmentMode.DEBUG || environmentMode == EnvironmentMode.TRACE) {
                greedySolverPhase.setAssertStepScoreIsUncorrupted(true);
            }
            return greedySolverPhase;
        }
        throw new IllegalArgumentException("A constructionHeuristic requires configuration, for example a constructionHeuristicType.");
    }

    private GreedyPlanningEntitySelector buildGreedyPlanningEntitySelector(SolutionDescriptor solutionDescriptor) {
        GreedyPlanningEntitySelector greedyPlanningEntitySelector = new GreedyPlanningEntitySelector();
        Set<Class<?>> planningEntityImplementationClassSet = solutionDescriptor.getPlanningEntityImplementationClassSet();
        if (planningEntityImplementationClassSet.size() != 1) {
            throw new UnsupportedOperationException("Currently the greedyFit implementation only supports 1 planningEntityImplementationClass.");
        }
        Class<?> planningEntityImplementationClass = planningEntityImplementationClassSet.iterator().next();
        ArrayList<PlanningEntitySelector> planningEntitySelectorList = new ArrayList<PlanningEntitySelector>(1);
        PlanningEntitySelector planningEntitySelector = new PlanningEntitySelector(solutionDescriptor.getPlanningEntityDescriptor(planningEntityImplementationClass));
        planningEntitySelector.setSelectionOrder(this.determinePlanningEntitySelectionOrder());
        planningEntitySelector.setResetInitializedPlanningEntities(false);
        planningEntitySelectorList.add(planningEntitySelector);
        greedyPlanningEntitySelector.setPlanningEntitySelectorList(planningEntitySelectorList);
        return greedyPlanningEntitySelector;
    }

    private GreedyDecider buildGreedyDecider(SolutionDescriptor solutionDescriptor, EnvironmentMode environmentMode) {
        DefaultGreedyDecider greedyDecider = new DefaultGreedyDecider();
        ConstructionHeuristicPickEarlyType pickEarlyType = this.constructionHeuristicPickEarlyType == null ? ConstructionHeuristicPickEarlyType.NEVER : this.constructionHeuristicPickEarlyType;
        Set<Class<?>> planningEntityImplementationClassSet = solutionDescriptor.getPlanningEntityImplementationClassSet();
        if (planningEntityImplementationClassSet.size() != 1) {
            throw new UnsupportedOperationException("Currently the greedyFit implementation only supports 1 planningEntityImplementationClass.");
        }
        Class<?> planningEntityImplementationClass = planningEntityImplementationClassSet.iterator().next();
        PlanningEntityDescriptor planningEntityDescriptor = solutionDescriptor.getPlanningEntityDescriptor(planningEntityImplementationClass);
        PlanningVariableWalker planningVariableWalker = new PlanningVariableWalker(planningEntityDescriptor);
        ArrayList<PlanningValueWalker> planningValueWalkerList = new ArrayList<PlanningValueWalker>();
        for (PlanningVariableDescriptor planningVariableDescriptor : planningEntityDescriptor.getPlanningVariableDescriptors()) {
            PlanningValueSelector planningValueSelector = new PlanningValueSelector(planningVariableDescriptor);
            planningValueSelector.setSelectionOrder(this.determinePlanningValueSelectionOrder());
            PlanningValueWalker planningValueWalker = new PlanningValueWalker(planningVariableDescriptor, planningValueSelector);
            planningValueWalkerList.add(planningValueWalker);
        }
        planningVariableWalker.setPlanningValueWalkerList(planningValueWalkerList);
        greedyDecider.setPlanningVariableWalker(planningVariableWalker);
        greedyDecider.setConstructionHeuristicPickEarlyType(pickEarlyType);
        if (environmentMode == EnvironmentMode.TRACE) {
            greedyDecider.setAssertMoveScoreIsUncorrupted(true);
        }
        return greedyDecider;
    }

    private PlanningEntitySelectionOrder determinePlanningEntitySelectionOrder() {
        switch (this.constructionHeuristicType) {
            case FIRST_FIT: 
            case BEST_FIT: {
                return PlanningEntitySelectionOrder.ORIGINAL;
            }
            case FIRST_FIT_DECREASING: 
            case BEST_FIT_DECREASING: {
                return PlanningEntitySelectionOrder.DECREASING_DIFFICULTY;
            }
        }
        throw new IllegalStateException("The constructionHeuristicType (" + (Object)((Object)this.constructionHeuristicType) + ") is not implemented");
    }

    private PlanningValueSelectionOrder determinePlanningValueSelectionOrder() {
        switch (this.constructionHeuristicType) {
            case FIRST_FIT: 
            case FIRST_FIT_DECREASING: {
                return PlanningValueSelectionOrder.ORIGINAL;
            }
            case BEST_FIT: 
            case BEST_FIT_DECREASING: {
                return PlanningValueSelectionOrder.INCREASING_STRENGTH;
            }
        }
        throw new IllegalStateException("The constructionHeuristicType (" + (Object)((Object)this.constructionHeuristicType) + ") is not implemented");
    }

    public void inherit(ConstructionHeuristicSolverPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.constructionHeuristicType == null) {
            this.constructionHeuristicType = inheritedConfig.getConstructionHeuristicType();
        }
        if (this.constructionHeuristicPickEarlyType == null) {
            this.constructionHeuristicPickEarlyType = inheritedConfig.getConstructionHeuristicPickEarlyType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConstructionHeuristicType {
        FIRST_FIT,
        FIRST_FIT_DECREASING,
        BEST_FIT,
        BEST_FIT_DECREASING;

    }
}

