/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.localsearch.decider.selector;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.drools.planner.core.localsearch.decider.selector.CompositeSelector;
import org.drools.planner.core.localsearch.decider.selector.MoveFactorySelector;
import org.drools.planner.core.localsearch.decider.selector.Selector;
import org.drools.planner.core.localsearch.decider.selector.TopListSelector;
import org.drools.planner.core.move.factory.MoveFactory;
import org.drools.planner.core.score.definition.ScoreDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="selector")
public class SelectorConfig {
    @XStreamImplicit(itemFieldName="selector")
    private List<SelectorConfig> selectorConfigList = null;
    private MoveFactory moveFactory = null;
    private Class<? extends MoveFactory> moveFactoryClass = null;
    protected Boolean shuffle = null;
    private Integer topSize = null;

    public List<SelectorConfig> getSelectorConfigList() {
        return this.selectorConfigList;
    }

    public void setSelectorConfigList(List<SelectorConfig> selectorConfigList) {
        this.selectorConfigList = selectorConfigList;
    }

    public MoveFactory getMoveFactory() {
        return this.moveFactory;
    }

    public void setMoveFactory(MoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Class<? extends MoveFactory> getMoveFactoryClass() {
        return this.moveFactoryClass;
    }

    public void setMoveFactoryClass(Class<? extends MoveFactory> moveFactoryClass) {
        this.moveFactoryClass = moveFactoryClass;
    }

    public Boolean getShuffle() {
        return this.shuffle;
    }

    public void setShuffle(Boolean shuffle) {
        this.shuffle = shuffle;
    }

    public Integer getTopSize() {
        return this.topSize;
    }

    public void setTopSize(Integer topSize) {
        this.topSize = topSize;
    }

    public Selector buildSelector(ScoreDefinition scoreDefinition) {
        if (this.selectorConfigList != null) {
            ArrayList<Selector> selectorList = new ArrayList<Selector>(this.selectorConfigList.size());
            for (SelectorConfig selectorConfig : this.selectorConfigList) {
                selectorList.add(selectorConfig.buildSelector(scoreDefinition));
            }
            CompositeSelector selector = new CompositeSelector();
            selector.setSelectorList(selectorList);
            return selector;
        }
        if (this.moveFactory != null || this.moveFactoryClass != null) {
            MoveFactory initializedMoveFactory;
            if (this.moveFactory != null) {
                initializedMoveFactory = this.moveFactory;
            } else {
                try {
                    initializedMoveFactory = this.moveFactoryClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("The moveFactoryClass (" + this.moveFactoryClass.getName() + ") does not have a public no-arg constructor", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("The moveFactoryClass (" + this.moveFactoryClass.getName() + ") does not have a public no-arg constructor", e);
                }
            }
            MoveFactorySelector selector = new MoveFactorySelector();
            selector.setMoveFactory(initializedMoveFactory);
            boolean shuffleValue = this.shuffle == null ? true : this.shuffle;
            selector.setShuffle(shuffleValue);
            return selector;
        }
        if (this.topSize != null) {
            TopListSelector selector = new TopListSelector();
            selector.setTopSize(this.topSize);
            return selector;
        }
        throw new IllegalArgumentException("A selector requires configuration, for example a moveFactoryClass.");
    }

    public void inherit(SelectorConfig inheritedConfig) {
        if (this.moveFactory == null && this.moveFactoryClass == null) {
            this.moveFactory = inheritedConfig.getMoveFactory();
            this.moveFactoryClass = inheritedConfig.getMoveFactoryClass();
        }
        if (this.selectorConfigList == null) {
            this.selectorConfigList = inheritedConfig.getSelectorConfigList();
        } else {
            List<SelectorConfig> inheritedSelectorConfigList = inheritedConfig.getSelectorConfigList();
            if (inheritedSelectorConfigList != null) {
                for (SelectorConfig selectorConfig : inheritedSelectorConfigList) {
                    this.selectorConfigList.add(selectorConfig);
                }
            }
        }
        if (this.shuffle == null) {
            this.shuffle = inheritedConfig.getShuffle();
        }
        if (this.topSize == null) {
            this.topSize = inheritedConfig.getTopSize();
        }
    }
}

