/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.termination;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.termination.AbstractCompositeTermination;
import org.drools.planner.core.termination.AbstractTermination;
import org.drools.planner.core.termination.AndCompositeTermination;
import org.drools.planner.core.termination.OrCompositeTermination;
import org.drools.planner.core.termination.ScoreAttainedTermination;
import org.drools.planner.core.termination.StepCountTermination;
import org.drools.planner.core.termination.Termination;
import org.drools.planner.core.termination.TimeMillisSpendTermination;
import org.drools.planner.core.termination.UnimprovedStepCountTermination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="termination")
public class TerminationConfig
implements Cloneable {
    private Class<Termination> terminationClass = null;
    private TerminationCompositionStyle terminationCompositionStyle = null;
    private Integer maximumStepCount = null;
    private Long maximumTimeMillisSpend = null;
    private Long maximumSecondsSpend = null;
    private Long maximumMinutesSpend = null;
    private Long maximumHoursSpend = null;
    private String scoreAttained = null;
    private Integer maximumUnimprovedStepCount = null;
    @XStreamImplicit(itemFieldName="termination")
    private List<TerminationConfig> terminationConfigList = null;

    public Class<Termination> getTerminationClass() {
        return this.terminationClass;
    }

    public void setTerminationClass(Class<Termination> terminationClass) {
        this.terminationClass = terminationClass;
    }

    public TerminationCompositionStyle getTerminationCompositionStyle() {
        return this.terminationCompositionStyle;
    }

    public void setTerminationCompositionStyle(TerminationCompositionStyle terminationCompositionStyle) {
        this.terminationCompositionStyle = terminationCompositionStyle;
    }

    public Integer getMaximumStepCount() {
        return this.maximumStepCount;
    }

    public void setMaximumStepCount(Integer maximumStepCount) {
        this.maximumStepCount = maximumStepCount;
    }

    public Long getMaximumTimeMillisSpend() {
        return this.maximumTimeMillisSpend;
    }

    public void setMaximumTimeMillisSpend(Long maximumTimeMillisSpend) {
        this.maximumTimeMillisSpend = maximumTimeMillisSpend;
    }

    public Long getMaximumSecondsSpend() {
        return this.maximumSecondsSpend;
    }

    public void setMaximumSecondsSpend(Long maximumSecondsSpend) {
        this.maximumSecondsSpend = maximumSecondsSpend;
    }

    public Long getMaximumMinutesSpend() {
        return this.maximumMinutesSpend;
    }

    public void setMaximumMinutesSpend(Long maximumMinutesSpend) {
        this.maximumMinutesSpend = maximumMinutesSpend;
    }

    public Long getMaximumHoursSpend() {
        return this.maximumHoursSpend;
    }

    public void setMaximumHoursSpend(Long maximumHoursSpend) {
        this.maximumHoursSpend = maximumHoursSpend;
    }

    public String getScoreAttained() {
        return this.scoreAttained;
    }

    public void setScoreAttained(String scoreAttained) {
        this.scoreAttained = scoreAttained;
    }

    public Integer getMaximumUnimprovedStepCount() {
        return this.maximumUnimprovedStepCount;
    }

    public void setMaximumUnimprovedStepCount(Integer maximumUnimprovedStepCount) {
        this.maximumUnimprovedStepCount = maximumUnimprovedStepCount;
    }

    public List<TerminationConfig> getTerminationConfigList() {
        return this.terminationConfigList;
    }

    public void setTerminationConfigList(List<TerminationConfig> terminationConfigList) {
        this.terminationConfigList = terminationConfigList;
    }

    public Termination buildTermination(ScoreDefinition scoreDefinition, Termination chainedTermination) {
        Termination termination = this.buildTermination(scoreDefinition);
        if (termination == null) {
            return chainedTermination;
        }
        return new OrCompositeTermination(chainedTermination, termination);
    }

    public Termination buildTermination(ScoreDefinition scoreDefinition) {
        AbstractTermination termination;
        Long maximumTimeMillisSpendTotal;
        ArrayList<Termination> terminationList = new ArrayList<Termination>();
        if (this.terminationClass != null) {
            try {
                terminationList.add(this.terminationClass.newInstance());
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("terminationClass (" + this.terminationClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("terminationClass (" + this.terminationClass.getName() + ") does not have a public no-arg constructor", e);
            }
        }
        if (this.maximumStepCount != null) {
            StepCountTermination termination2 = new StepCountTermination();
            termination2.setMaximumStepCount(this.maximumStepCount);
            terminationList.add(termination2);
        }
        if ((maximumTimeMillisSpendTotal = this.calculateMaximumTimeMillisSpendTotal()) != null) {
            termination = new TimeMillisSpendTermination();
            ((TimeMillisSpendTermination)termination).setMaximumTimeMillisSpend(maximumTimeMillisSpendTotal);
            terminationList.add(termination);
        }
        if (this.scoreAttained != null) {
            termination = new ScoreAttainedTermination();
            ((ScoreAttainedTermination)termination).setScoreAttained(scoreDefinition.parseScore(this.scoreAttained));
            terminationList.add(termination);
        }
        if (this.maximumUnimprovedStepCount != null) {
            termination = new UnimprovedStepCountTermination();
            ((UnimprovedStepCountTermination)termination).setMaximumUnimprovedStepCount(this.maximumUnimprovedStepCount);
            terminationList.add(termination);
        }
        if (this.terminationConfigList != null && this.terminationConfigList.isEmpty()) {
            for (TerminationConfig terminationConfig : this.terminationConfigList) {
                Termination termination3 = terminationConfig.buildTermination(scoreDefinition);
                if (termination3 == null) continue;
                terminationList.add(termination3);
            }
        }
        if (terminationList.size() == 1) {
            return (Termination)terminationList.get(0);
        }
        if (terminationList.size() > 1) {
            AbstractCompositeTermination compositeTermination;
            if (this.terminationCompositionStyle == null || this.terminationCompositionStyle == TerminationCompositionStyle.OR) {
                compositeTermination = new OrCompositeTermination();
            } else if (this.terminationCompositionStyle == TerminationCompositionStyle.AND) {
                compositeTermination = new AndCompositeTermination();
            } else {
                throw new IllegalStateException("The terminationCompositionStyle (" + (Object)((Object)this.terminationCompositionStyle) + ") is not implemented");
            }
            compositeTermination.setTerminationList(terminationList);
            return compositeTermination;
        }
        return null;
    }

    public Long calculateMaximumTimeMillisSpendTotal() {
        if (this.maximumTimeMillisSpend == null && this.maximumSecondsSpend == null && this.maximumMinutesSpend == null && this.maximumHoursSpend == null) {
            return null;
        }
        long maximumTimeMillisSpendTotal = 0L;
        if (this.maximumTimeMillisSpend != null) {
            maximumTimeMillisSpendTotal += this.maximumTimeMillisSpend.longValue();
        }
        if (this.maximumSecondsSpend != null) {
            maximumTimeMillisSpendTotal += this.maximumSecondsSpend * 1000L;
        }
        if (this.maximumMinutesSpend != null) {
            maximumTimeMillisSpendTotal += this.maximumMinutesSpend * 60000L;
        }
        if (this.maximumHoursSpend != null) {
            maximumTimeMillisSpendTotal += this.maximumHoursSpend * 3600000L;
        }
        return maximumTimeMillisSpendTotal;
    }

    public void shortenMaximumTimeMillisSpendTotal(long maximumTimeMillisSpendTotal) {
        Long oldMaximumTimeMillisSpendTotal = this.calculateMaximumTimeMillisSpendTotal();
        if (oldMaximumTimeMillisSpendTotal == null || maximumTimeMillisSpendTotal < oldMaximumTimeMillisSpendTotal) {
            this.maximumTimeMillisSpend = maximumTimeMillisSpendTotal;
            this.maximumSecondsSpend = null;
            this.maximumMinutesSpend = null;
            this.maximumHoursSpend = null;
        }
    }

    public void inherit(TerminationConfig inheritedConfig) {
        if (this.terminationClass == null) {
            this.terminationClass = inheritedConfig.getTerminationClass();
        }
        if (this.terminationCompositionStyle == null) {
            this.terminationCompositionStyle = inheritedConfig.getTerminationCompositionStyle();
        }
        if (this.maximumStepCount == null) {
            this.maximumStepCount = inheritedConfig.getMaximumStepCount();
        }
        if (this.maximumTimeMillisSpend == null) {
            this.maximumTimeMillisSpend = inheritedConfig.getMaximumTimeMillisSpend();
        }
        if (this.maximumSecondsSpend == null) {
            this.maximumSecondsSpend = inheritedConfig.getMaximumSecondsSpend();
        }
        if (this.maximumMinutesSpend == null) {
            this.maximumMinutesSpend = inheritedConfig.getMaximumMinutesSpend();
        }
        if (this.maximumHoursSpend == null) {
            this.maximumHoursSpend = inheritedConfig.getMaximumHoursSpend();
        }
        if (this.scoreAttained == null) {
            this.scoreAttained = inheritedConfig.getScoreAttained();
        }
        if (this.maximumUnimprovedStepCount == null) {
            this.maximumUnimprovedStepCount = inheritedConfig.getMaximumUnimprovedStepCount();
        }
        if (this.terminationConfigList == null) {
            this.terminationConfigList = inheritedConfig.getTerminationConfigList();
        } else if (inheritedConfig.getTerminationConfigList() != null) {
            ArrayList<TerminationConfig> mergedList = new ArrayList<TerminationConfig>(inheritedConfig.getTerminationConfigList());
            mergedList.addAll(this.terminationConfigList);
            this.terminationConfigList = mergedList;
        }
    }

    public TerminationConfig clone() {
        TerminationConfig clone = new TerminationConfig();
        clone.terminationClass = this.terminationClass;
        clone.terminationCompositionStyle = this.terminationCompositionStyle;
        clone.maximumStepCount = this.maximumStepCount;
        clone.maximumTimeMillisSpend = this.maximumTimeMillisSpend;
        clone.maximumSecondsSpend = this.maximumSecondsSpend;
        clone.maximumMinutesSpend = this.maximumMinutesSpend;
        clone.maximumHoursSpend = this.maximumHoursSpend;
        clone.scoreAttained = this.scoreAttained;
        clone.maximumUnimprovedStepCount = this.maximumUnimprovedStepCount;
        if (this.terminationConfigList != null) {
            ArrayList<TerminationConfig> clonedTerminationConfigList = new ArrayList<TerminationConfig>(this.terminationConfigList.size());
            for (TerminationConfig terminationConfig : this.terminationConfigList) {
                TerminationConfig clonedTerminationConfig = terminationConfig.clone();
                clonedTerminationConfigList.add(clonedTerminationConfig);
            }
            clone.terminationConfigList = clonedTerminationConfigList;
        }
        return clone;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TerminationCompositionStyle {
        AND,
        OR;

    }
}

