/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.variable;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueWalker;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.step.AbstractStepScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningVariableWalker
implements SolverPhaseLifecycleListener {
    private final PlanningEntityDescriptor planningEntityDescriptor;
    private List<PlanningValueWalker> planningValueWalkerList;
    private WorkingMemory workingMemory;
    private Object planningEntity;
    private FactHandle planningEntityFactHandle;

    public PlanningVariableWalker(PlanningEntityDescriptor planningEntityDescriptor) {
        this.planningEntityDescriptor = planningEntityDescriptor;
    }

    public void setPlanningValueWalkerList(List<PlanningValueWalker> planningValueWalkerList) {
        this.planningValueWalkerList = planningValueWalkerList;
    }

    public Map<PlanningVariableDescriptor, Object> getVariableToValueMap() {
        LinkedHashMap<PlanningVariableDescriptor, Object> variableToValueMap = new LinkedHashMap<PlanningVariableDescriptor, Object>(this.planningValueWalkerList.size());
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            variableToValueMap.put(planningValueWalker.getPlanningVariableDescriptor(), planningValueWalker.getWorkingValue());
        }
        return variableToValueMap;
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope solverPhaseScope) {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.phaseStarted(solverPhaseScope);
        }
        this.workingMemory = solverPhaseScope.getWorkingMemory();
    }

    @Override
    public void beforeDeciding(AbstractStepScope stepScope) {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.beforeDeciding(stepScope);
        }
    }

    @Override
    public void stepDecided(AbstractStepScope stepScope) {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.stepDecided(stepScope);
        }
    }

    @Override
    public void stepTaken(AbstractStepScope stepScope) {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.stepTaken(stepScope);
        }
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope solverPhaseScope) {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.phaseEnded(solverPhaseScope);
        }
        this.workingMemory = null;
        this.planningEntity = null;
    }

    public void initWalk(Object planningEntity) {
        this.planningEntity = planningEntity;
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.initWalk(planningEntity);
        }
        this.planningEntityFactHandle = this.workingMemory.insert(planningEntity);
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.initPlanningEntityFactHandle(this.planningEntityFactHandle);
        }
    }

    public boolean hasWalk() {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            if (!planningValueWalker.hasWalk()) continue;
            return true;
        }
        return false;
    }

    public void walk() {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            if (planningValueWalker.hasWalk()) {
                planningValueWalker.walk();
                break;
            }
            planningValueWalker.resetWalk();
        }
    }

    public void resetWalk() {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.resetWalk();
        }
    }
}

