/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider;

import java.util.Iterator;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.LocalSearchSolverPhase;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.Acceptor;
import org.drools.planner.core.localsearch.decider.deciderscorecomparator.DeciderScoreComparatorFactory;
import org.drools.planner.core.localsearch.decider.forager.Forager;
import org.drools.planner.core.localsearch.decider.selector.Selector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.Score;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDecider
implements Decider {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected LocalSearchSolverPhase localSearchSolverPhase;
    protected DeciderScoreComparatorFactory deciderScoreComparatorFactory;
    protected Selector selector;
    protected Acceptor acceptor;
    protected Forager forager;
    protected boolean assertMoveScoreIsUncorrupted = false;
    protected boolean assertUndoMoveIsUncorrupted = false;

    public void setLocalSearchSolverPhase(LocalSearchSolverPhase localSearchSolverPhase) {
        this.localSearchSolverPhase = localSearchSolverPhase;
    }

    public DeciderScoreComparatorFactory getDeciderScoreComparator() {
        return this.deciderScoreComparatorFactory;
    }

    public void setDeciderScoreComparator(DeciderScoreComparatorFactory deciderScoreComparator) {
        this.deciderScoreComparatorFactory = deciderScoreComparator;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
        selector.setDecider(this);
    }

    public void setAcceptor(Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    public Forager getForager() {
        return this.forager;
    }

    public void setForager(Forager forager) {
        this.forager = forager;
    }

    public void setAssertMoveScoreIsUncorrupted(boolean assertMoveScoreIsUncorrupted) {
        this.assertMoveScoreIsUncorrupted = assertMoveScoreIsUncorrupted;
    }

    public void setAssertUndoMoveIsUncorrupted(boolean assertUndoMoveIsUncorrupted) {
        this.assertUndoMoveIsUncorrupted = assertUndoMoveIsUncorrupted;
    }

    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.deciderScoreComparatorFactory.phaseStarted(localSearchSolverPhaseScope);
        this.selector.phaseStarted(localSearchSolverPhaseScope);
        this.acceptor.phaseStarted(localSearchSolverPhaseScope);
        this.forager.phaseStarted(localSearchSolverPhaseScope);
    }

    public void beforeDeciding(LocalSearchStepScope localSearchStepScope) {
        this.deciderScoreComparatorFactory.beforeDeciding(localSearchStepScope);
        localSearchStepScope.setDeciderScoreComparator(this.deciderScoreComparatorFactory.createDeciderScoreComparator());
        this.selector.beforeDeciding(localSearchStepScope);
        this.acceptor.beforeDeciding(localSearchStepScope);
        this.forager.beforeDeciding(localSearchStepScope);
    }

    public void decideNextStep(LocalSearchStepScope localSearchStepScope) {
        MoveScope pickedMoveScope;
        WorkingMemory workingMemory = localSearchStepScope.getWorkingMemory();
        Iterator<Move> moveIterator = this.selector.moveIterator(localSearchStepScope);
        while (moveIterator.hasNext()) {
            Move move = moveIterator.next();
            MoveScope moveScope = new MoveScope(localSearchStepScope);
            moveScope.setMove(move);
            if (move.isMoveDoable(workingMemory)) {
                this.doMove(moveScope);
                if (!this.forager.isQuitEarly()) continue;
                break;
            }
            this.logger.trace("        Ignoring not doable move ({}).", (Object)move);
        }
        if ((pickedMoveScope = this.forager.pickMove(localSearchStepScope)) != null) {
            Move step = pickedMoveScope.getMove();
            localSearchStepScope.setStep(step);
            if (this.logger.isDebugEnabled()) {
                localSearchStepScope.setStepString(step.toString());
            }
            localSearchStepScope.setUndoStep(step.createUndoMove(workingMemory));
            localSearchStepScope.setScore(pickedMoveScope.getScore());
        }
    }

    private void doMove(MoveScope moveScope) {
        Score lastCompletedStepScore;
        Score undoScore;
        WorkingMemory workingMemory = moveScope.getWorkingMemory();
        Move move = moveScope.getMove();
        Move undoMove = move.createUndoMove(workingMemory);
        moveScope.setUndoMove(undoMove);
        move.doMove(workingMemory);
        this.processMove(moveScope);
        undoMove.doMove(workingMemory);
        if (this.assertUndoMoveIsUncorrupted && !(undoScore = moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope().calculateScoreFromWorkingMemory()).equals(lastCompletedStepScore = moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope().getLastCompletedLocalSearchStepScope().getScore())) {
            throw new IllegalStateException("Corrupted undo move (" + undoMove + ") received from move (" + move + ").\n" + "Unequal lastCompletedStepScore (" + lastCompletedStepScore + ") and undoScore (" + undoScore + ").\n" + moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope().getSolverScope().getSolutionDirector().buildConstraintOccurrenceSummary());
        }
        this.logger.trace("        Move score ({}), accept chance ({}) for move ({}).", new Object[]{moveScope.getScore(), moveScope.getAcceptChance(), moveScope.getMove()});
    }

    private void processMove(MoveScope moveScope) {
        Score score = moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope().calculateScoreFromWorkingMemory();
        if (this.assertMoveScoreIsUncorrupted) {
            moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope().assertWorkingScore(score);
        }
        moveScope.setScore(score);
        double acceptChance = this.acceptor.calculateAcceptChance(moveScope);
        moveScope.setAcceptChance(acceptChance);
        this.forager.addMove(moveScope);
    }

    public void stepDecided(LocalSearchStepScope localSearchStepScope) {
        this.deciderScoreComparatorFactory.stepDecided(localSearchStepScope);
        this.selector.stepDecided(localSearchStepScope);
        this.acceptor.stepDecided(localSearchStepScope);
        this.forager.stepDecided(localSearchStepScope);
    }

    public void stepTaken(LocalSearchStepScope localSearchStepScope) {
        this.deciderScoreComparatorFactory.stepTaken(localSearchStepScope);
        this.selector.stepTaken(localSearchStepScope);
        this.acceptor.stepTaken(localSearchStepScope);
        this.forager.stepTaken(localSearchStepScope);
    }

    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.deciderScoreComparatorFactory.phaseEnded(localSearchSolverPhaseScope);
        this.selector.phaseEnded(localSearchSolverPhaseScope);
        this.acceptor.phaseEnded(localSearchSolverPhaseScope);
        this.forager.phaseEnded(localSearchSolverPhaseScope);
    }
}

