/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.simulatedannealing;

import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;
import org.drools.planner.core.score.Score;

public class SimulatedAnnealingAcceptor
extends AbstractAcceptor {
    protected Score startingTemperature;
    protected int partsLength;
    protected double[] startingTemperatureParts;
    protected double[] temperatureParts;
    protected double temperatureMinimum = 1.0E-100;

    public void setStartingTemperature(Score startingTemperature) {
        this.startingTemperature = startingTemperature;
    }

    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        for (double startingTemperaturePart : this.startingTemperature.toDoubleArray()) {
            if (!(startingTemperaturePart < 0.0)) continue;
            throw new IllegalArgumentException("The startingTemperature (" + this.startingTemperature + ") cannot have negative part (" + startingTemperaturePart + ").");
        }
        this.startingTemperatureParts = this.startingTemperature.toDoubleArray();
        this.temperatureParts = this.startingTemperatureParts;
        this.partsLength = this.startingTemperatureParts.length;
    }

    public double calculateAcceptChance(MoveScope moveScope) {
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope();
        Score lastStepScore = localSearchSolverPhaseScope.getLastCompletedLocalSearchStepScope().getScore();
        Score moveScore = moveScope.getScore();
        if (moveScore.compareTo(lastStepScore) >= 0) {
            return 1.0;
        }
        Score scoreDifference = lastStepScore.subtract(moveScore);
        double acceptChance = 1.0;
        double[] scoreDifferenceParts = scoreDifference.toDoubleArray();
        for (int i = 0; i < this.partsLength; ++i) {
            double scoreDifferencePart = scoreDifferenceParts[i];
            double temperaturePart = this.temperatureParts[i];
            double acceptChancePart = scoreDifferencePart <= 0.0 ? 1.0 : Math.exp(-scoreDifferencePart / temperaturePart);
            acceptChance *= acceptChancePart;
        }
        if (moveScope.getWorkingRandom().nextDouble() < acceptChance) {
            return 1.0;
        }
        return 0.0;
    }

    public void stepTaken(LocalSearchStepScope localSearchStepScope) {
        super.stepTaken(localSearchStepScope);
        double timeGradient = localSearchStepScope.getTimeGradient();
        double reverseTimeGradient = 1.0 - timeGradient;
        this.temperatureParts = new double[this.partsLength];
        for (int i = 0; i < this.partsLength; ++i) {
            this.temperatureParts[i] = this.startingTemperatureParts[i] * reverseTimeGradient;
            if (!(this.temperatureParts[i] < this.temperatureMinimum)) continue;
            this.temperatureParts[i] = this.temperatureMinimum;
        }
    }
}

