/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.tabu;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTabuAcceptor
extends AbstractAcceptor {
    protected int completeTabuSize = -1;
    protected int partialTabuSize = 0;
    protected boolean aspirationEnabled = true;
    protected boolean assertTabuHashCodeCorrectness = false;
    protected Map<Object, Integer> tabuToStepIndexMap;
    protected List<Object> tabuSequenceList;

    public int getCompleteTabuSize() {
        return this.completeTabuSize;
    }

    public void setCompleteTabuSize(int completeTabuSize) {
        this.completeTabuSize = completeTabuSize;
    }

    public void setPartialTabuSize(int partialTabuSize) {
        this.partialTabuSize = partialTabuSize;
    }

    public void setAspirationEnabled(boolean aspirationEnabled) {
        this.aspirationEnabled = aspirationEnabled;
    }

    public void setAssertTabuHashCodeCorrectness(boolean assertTabuHashCodeCorrectness) {
        this.assertTabuHashCodeCorrectness = assertTabuHashCodeCorrectness;
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.validateConfiguration();
        this.tabuToStepIndexMap = new HashMap<Object, Integer>(this.completeTabuSize + this.partialTabuSize);
        this.tabuSequenceList = new LinkedList<Object>();
    }

    private void validateConfiguration() {
        if (this.completeTabuSize < 0) {
            throw new IllegalArgumentException("The completeTabuSize (" + this.completeTabuSize + ") cannot be negative.");
        }
        if (this.partialTabuSize < 0) {
            throw new IllegalArgumentException("The partialTabuSize (" + this.partialTabuSize + ") cannot be negative.");
        }
        if (this.completeTabuSize + this.partialTabuSize == 0) {
            throw new IllegalArgumentException("The sum of completeTabuSize and partialTabuSize should be at least 1.");
        }
    }

    @Override
    public double calculateAcceptChance(MoveScope moveScope) {
        Collection<? extends Object> checkingTabus = this.findTabu(moveScope);
        int maximumTabuStepIndex = -1;
        for (Object object : checkingTabus) {
            Integer tabuStepIndexInteger = this.tabuToStepIndexMap.get(object);
            if (tabuStepIndexInteger != null) {
                maximumTabuStepIndex = Math.max(tabuStepIndexInteger, maximumTabuStepIndex);
            }
            if (!this.assertTabuHashCodeCorrectness) continue;
            for (Object tabu : this.tabuSequenceList) {
                if (!tabu.equals(object)) continue;
                if (tabu.hashCode() != object.hashCode()) {
                    throw new IllegalStateException("HashCode violation: tabu (" + tabu + ") and checkingTabu (" + object + ") are equal but have a different hashCode.");
                }
                if (tabuStepIndexInteger != null) continue;
                throw new IllegalStateException("HashCode violation: the hashCode of tabu (" + tabu + ") probably changed since it was inserted in the tabu Map or Set.");
            }
        }
        if (maximumTabuStepIndex < 0) {
            return 1.0;
        }
        if (this.aspirationEnabled && moveScope.getScore().compareTo(moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope().getBestScore()) > 0) {
            this.logger.trace("        Proposed move ({}) is tabu, but aspiration undoes its tabu.", (Object)moveScope.getMove());
            return 1.0;
        }
        int tabuStepCount = moveScope.getLocalSearchStepScope().getStepIndex() - maximumTabuStepIndex - 1;
        if (tabuStepCount < this.completeTabuSize) {
            this.logger.trace("        Proposed move ({}) is complete tabu.", (Object)moveScope.getMove());
            return 0.0;
        }
        double d = this.calculatePartialTabuAcceptChance(tabuStepCount - this.completeTabuSize);
        this.logger.trace("        Proposed move ({}) is partially tabu with accept chance ({}).", (Object)moveScope.getMove(), (Object)d);
        return d;
    }

    protected double calculatePartialTabuAcceptChance(int partialTabuTime) {
        return (double)(partialTabuTime + 1) / (double)(this.partialTabuSize + 1);
    }

    @Override
    public void stepTaken(LocalSearchStepScope localSearchStepScope) {
        Collection<? extends Object> tabus = this.findNewTabu(localSearchStepScope);
        for (Object object : tabus) {
            if (this.tabuToStepIndexMap.containsKey(object)) {
                this.tabuToStepIndexMap.remove(object);
                this.tabuSequenceList.remove(object);
            }
            int maximumTabuListSize = this.completeTabuSize + this.partialTabuSize;
            while (this.tabuSequenceList.size() >= maximumTabuListSize) {
                Iterator<Object> it = this.tabuSequenceList.iterator();
                Object removeTabu = it.next();
                it.remove();
                this.tabuToStepIndexMap.remove(removeTabu);
            }
            this.tabuToStepIndexMap.put(object, localSearchStepScope.getStepIndex());
            this.tabuSequenceList.add(object);
        }
    }

    protected abstract Collection<? extends Object> findTabu(MoveScope var1);

    protected abstract Collection<? extends Object> findNewTabu(LocalSearchStepScope var1);
}

