/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.definition;

import org.drools.planner.core.score.DefaultSimpleDoubleScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.SimpleDoubleScore;
import org.drools.planner.core.score.calculator.ScoreCalculator;
import org.drools.planner.core.score.calculator.SimpleDoubleScoreCalculator;
import org.drools.planner.core.score.definition.AbstractScoreDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDoubleScoreDefinition
extends AbstractScoreDefinition<SimpleDoubleScore> {
    private SimpleDoubleScore perfectMaximumScore = new DefaultSimpleDoubleScore(0.0);
    private SimpleDoubleScore perfectMinimumScore = new DefaultSimpleDoubleScore(-1.7976931348623157E308);

    public void setPerfectMaximumScore(SimpleDoubleScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    public void setPerfectMinimumScore(SimpleDoubleScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public SimpleDoubleScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    @Override
    public SimpleDoubleScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    @Override
    public Score parseScore(String scoreString) {
        return DefaultSimpleDoubleScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(SimpleDoubleScore startScore, SimpleDoubleScore endScore, SimpleDoubleScore score) {
        if (score.getScore() >= endScore.getScore()) {
            return 1.0;
        }
        if (startScore.getScore() >= score.getScore()) {
            return 0.0;
        }
        double scoreTotal = endScore.getScore() - startScore.getScore();
        double scoreDelta = score.getScore() - startScore.getScore();
        return scoreDelta / scoreTotal;
    }

    @Override
    public Double translateScoreToGraphValue(SimpleDoubleScore score) {
        return score.getScore();
    }

    @Override
    public ScoreCalculator buildScoreCalculator() {
        return new SimpleDoubleScoreCalculator();
    }
}

