/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.solver;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.planner.core.Solver;
import org.drools.planner.core.bestsolution.BestSolutionRecaller;
import org.drools.planner.core.event.SolverEventListener;
import org.drools.planner.core.event.SolverEventSupport;
import org.drools.planner.core.phase.SolverPhase;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solution.director.DefaultSolutionDirector;
import org.drools.planner.core.solver.BasicPlumbingTermination;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.drools.planner.core.solver.ProblemFactChange;
import org.drools.planner.core.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSolver
implements Solver {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolverEventSupport solverEventSupport = new SolverEventSupport(this);
    protected Long randomSeed;
    protected BasicPlumbingTermination basicPlumbingTermination;
    protected Termination termination;
    protected BestSolutionRecaller bestSolutionRecaller;
    protected List<SolverPhase> solverPhaseList;
    protected AtomicBoolean solving = new AtomicBoolean(false);
    protected DefaultSolverScope solverScope = new DefaultSolverScope();

    public void setRandomSeed(long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public void setSolutionDirector(DefaultSolutionDirector solutionDirector) {
        this.solverScope.setSolutionDirector(solutionDirector);
    }

    @Override
    public ScoreDefinition getScoreDefinition() {
        return this.solverScope.getScoreDefinition();
    }

    public void setBasicPlumbingTermination(BasicPlumbingTermination basicPlumbingTermination) {
        this.basicPlumbingTermination = basicPlumbingTermination;
    }

    public void setTermination(Termination termination) {
        this.termination = termination;
    }

    public void setBestSolutionRecaller(BestSolutionRecaller bestSolutionRecaller) {
        this.bestSolutionRecaller = bestSolutionRecaller;
        this.bestSolutionRecaller.setSolverEventSupport(this.solverEventSupport);
    }

    public List<SolverPhase> getSolverPhaseList() {
        return this.solverPhaseList;
    }

    public void setSolverPhaseList(List<SolverPhase> solverPhaseList) {
        this.solverPhaseList = solverPhaseList;
    }

    @Override
    public void setPlanningProblem(Solution planningProblem) {
        this.solverScope.getSolutionDirector().setWorkingSolution(planningProblem);
    }

    @Override
    public Solution getBestSolution() {
        return this.solverScope.getBestSolution();
    }

    @Override
    public long getTimeMillisSpend() {
        return this.solverScope.calculateTimeMillisSpend();
    }

    public DefaultSolverScope getSolverScope() {
        return this.solverScope;
    }

    @Override
    public boolean isSolving() {
        return this.solving.get();
    }

    @Override
    public boolean terminateEarly() {
        return this.basicPlumbingTermination.terminateEarly();
    }

    @Override
    public boolean isTerminateEarly() {
        return this.basicPlumbingTermination.isTerminateEarly();
    }

    @Override
    public boolean addProblemFactChange(ProblemFactChange problemFactChange) {
        return this.basicPlumbingTermination.addProblemFactChange(problemFactChange);
    }

    @Override
    public final void solve() {
        this.solving.set(true);
        this.basicPlumbingTermination.resetTerminateEarly();
        this.solverScope.setRestartSolver(true);
        while (this.solverScope.isRestartSolver()) {
            this.solverScope.setRestartSolver(false);
            this.solvingStarted(this.solverScope);
            this.runSolverPhases();
            this.solvingEnded(this.solverScope);
            this.checkProblemFactChanges();
        }
        this.solving.set(false);
    }

    public void solvingStarted(DefaultSolverScope solverScope) {
        if (solverScope.getSolutionDirector().getWorkingSolution() == null) {
            throw new IllegalStateException("The planningProblem must not be null. Use Solver.setPlanningProblem(Solution).");
        }
        solverScope.reset();
        if (this.randomSeed != null) {
            solverScope.setWorkingRandom(new Random(this.randomSeed));
        } else {
            solverScope.setWorkingRandom(new Random());
        }
        this.bestSolutionRecaller.solvingStarted(solverScope);
        this.logger.info("Solver started: time spend ({}), score ({}), new best score ({}), random seed ({}).", new Object[]{solverScope.calculateTimeMillisSpend(), solverScope.getStartingInitializedScore(), solverScope.getBestScore(), this.randomSeed != null ? this.randomSeed : "not fixed"});
    }

    protected void runSolverPhases() {
        Iterator<SolverPhase> it = this.solverPhaseList.iterator();
        while (!this.termination.isSolverTerminated(this.solverScope) && it.hasNext()) {
            SolverPhase solverPhase = it.next();
            solverPhase.solve(this.solverScope);
        }
    }

    public void solvingEnded(DefaultSolverScope solverScope) {
        this.bestSolutionRecaller.solvingEnded(solverScope);
        long timeMillisSpend = solverScope.calculateTimeMillisSpend();
        if (timeMillisSpend == 0L) {
            timeMillisSpend = 1L;
        }
        long averageCalculateCountPerSecond = solverScope.getCalculateCount() * 1000L / timeMillisSpend;
        this.logger.info("Solved: time spend ({}), best score ({}), average calculate count per second ({}).", new Object[]{timeMillisSpend, solverScope.getBestScore(), averageCalculateCountPerSecond});
    }

    private void checkProblemFactChanges() {
        BlockingQueue<ProblemFactChange> problemFactChangeQueue = this.basicPlumbingTermination.getProblemFactChangeQueue();
        if (!problemFactChangeQueue.isEmpty()) {
            this.solverScope.setRestartSolver(true);
            Score score = null;
            int count = 0;
            ProblemFactChange problemFactChange = (ProblemFactChange)problemFactChangeQueue.poll();
            while (problemFactChange != null) {
                score = this.doProblemFactChange(problemFactChange);
                ++count;
                problemFactChange = (ProblemFactChange)problemFactChangeQueue.poll();
            }
            this.logger.info("Done {} ProblemFactChange(s): new score ({}) possibly uninitialized. Restarting solver.", (Object)count, (Object)score);
        }
    }

    private Score doProblemFactChange(ProblemFactChange problemFactChange) {
        problemFactChange.doChange(this.solverScope.getSolutionDirector());
        Score score = this.solverScope.calculateScoreFromWorkingMemory();
        this.logger.debug("    Done ProblemFactChange: new score ({}).", (Object)score);
        return score;
    }

    @Override
    public void addEventListener(SolverEventListener eventListener) {
        this.solverEventSupport.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(SolverEventListener eventListener) {
        this.solverEventSupport.removeEventListener(eventListener);
    }

    public void addSolverPhaseLifecycleListener(SolverPhaseLifecycleListener solverPhaseLifecycleListener) {
        for (SolverPhase solverPhase : this.solverPhaseList) {
            solverPhase.addSolverPhaseLifecycleListener(solverPhaseLifecycleListener);
        }
    }

    public void removeSolverPhaseLifecycleListener(SolverPhaseLifecycleListener solverPhaseLifecycleListener) {
        for (SolverPhase solverPhase : this.solverPhaseList) {
            solverPhase.addSolverPhaseLifecycleListener(solverPhaseLifecycleListener);
        }
    }
}

