/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.solver;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.drools.WorkingMemory;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solution.director.DefaultSolutionDirector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSolverScope {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected DefaultSolutionDirector solutionDirector;
    protected boolean restartSolver = false;
    protected long startingSystemTimeMillis;
    protected Random workingRandom;
    protected Score startingInitializedScore;
    protected Solution bestSolution;
    protected Score bestScore;

    public DefaultSolutionDirector getSolutionDirector() {
        return this.solutionDirector;
    }

    public void setSolutionDirector(DefaultSolutionDirector solutionDirector) {
        this.solutionDirector = solutionDirector;
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solutionDirector.getSolutionDescriptor();
    }

    public ScoreDefinition getScoreDefinition() {
        return this.solutionDirector.getScoreDefinition();
    }

    public long getStartingSystemTimeMillis() {
        return this.startingSystemTimeMillis;
    }

    public void setStartingSystemTimeMillis(long startingSystemTimeMillis) {
        this.startingSystemTimeMillis = startingSystemTimeMillis;
    }

    public boolean isRestartSolver() {
        return this.restartSolver;
    }

    public void setRestartSolver(boolean restartSolver) {
        this.restartSolver = restartSolver;
    }

    public Solution getWorkingSolution() {
        return this.solutionDirector.getWorkingSolution();
    }

    public Collection<Object> getWorkingFacts() {
        return this.solutionDirector.getWorkingFacts();
    }

    public List<Object> getWorkingPlanningEntityList() {
        return this.solutionDirector.getWorkingPlanningEntityList();
    }

    public boolean isWorkingSolutionInitialized() {
        return this.solutionDirector.isWorkingSolutionInitialized();
    }

    public WorkingMemory getWorkingMemory() {
        return this.solutionDirector.getWorkingMemory();
    }

    public Score calculateScoreFromWorkingMemory() {
        return this.solutionDirector.calculateScoreFromWorkingMemory();
    }

    public void assertWorkingScore(Score presumedScore) {
        this.solutionDirector.assertWorkingScore(presumedScore);
    }

    public Random getWorkingRandom() {
        return this.workingRandom;
    }

    public void setWorkingRandom(Random workingRandom) {
        this.workingRandom = workingRandom;
    }

    public Score getStartingInitializedScore() {
        return this.startingInitializedScore;
    }

    public void setStartingInitializedScore(Score startingInitializedScore) {
        this.startingInitializedScore = startingInitializedScore;
    }

    public long getCalculateCount() {
        return this.solutionDirector.getCalculateCount();
    }

    public Solution getBestSolution() {
        return this.bestSolution;
    }

    public void setBestSolution(Solution bestSolution) {
        this.bestSolution = bestSolution;
    }

    public Score getBestScore() {
        return this.bestScore;
    }

    public void setBestScore(Score bestScore) {
        this.bestScore = bestScore;
    }

    public void reset() {
        this.startingSystemTimeMillis = System.currentTimeMillis();
        this.solutionDirector.resetCalculateCount();
    }

    public long calculateTimeMillisSpend() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }
}

