/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.termination;

import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.drools.planner.core.termination.AbstractTermination;

public class StepCountTermination
extends AbstractTermination {
    private int maximumStepCount = 100;

    public void setMaximumStepCount(int maximumStepCount) {
        this.maximumStepCount = maximumStepCount;
        if (maximumStepCount < 0) {
            throw new IllegalArgumentException("Property maximumStepCount (" + maximumStepCount + ") must be greater or equal to 0.");
        }
    }

    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException("StepCountTermination can only be used for phase termination.");
    }

    public boolean isPhaseTerminated(AbstractSolverPhaseScope solverPhaseScope) {
        int nextStepIndex = solverPhaseScope.getLastCompletedStepScope().getStepIndex() + 1;
        return nextStepIndex >= this.maximumStepCount;
    }

    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException("StepCountTermination can only be used for phase termination.");
    }

    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope solverPhaseScope) {
        int nextStepIndex = solverPhaseScope.getLastCompletedStepScope().getStepIndex() + 1;
        double timeGradient = (double)nextStepIndex / (double)this.maximumStepCount;
        return Math.min(timeGradient, 1.0);
    }
}

