/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.termination;

import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.drools.planner.core.termination.AbstractTermination;

public class UnimprovedStepCountTermination
extends AbstractTermination {
    private int maximumUnimprovedStepCount = 100;

    public void setMaximumUnimprovedStepCount(int maximumUnimprovedStepCount) {
        this.maximumUnimprovedStepCount = maximumUnimprovedStepCount;
        if (maximumUnimprovedStepCount < 0) {
            throw new IllegalArgumentException("Property maximumUnimprovedStepCount (" + maximumUnimprovedStepCount + ") must be greater or equal to 0.");
        }
    }

    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException("StepCountTermination can only be used for phase termination.");
    }

    public boolean isPhaseTerminated(AbstractSolverPhaseScope solverPhaseScope) {
        int unimprovedStepCount = this.calculateUnimprovedStepCount(solverPhaseScope);
        return unimprovedStepCount >= this.maximumUnimprovedStepCount;
    }

    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException("StepCountTermination can only be used for phase termination.");
    }

    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope solverPhaseScope) {
        int unimprovedStepCount = this.calculateUnimprovedStepCount(solverPhaseScope);
        double timeGradient = (double)unimprovedStepCount / (double)this.maximumUnimprovedStepCount;
        return Math.min(timeGradient, 1.0);
    }

    private int calculateUnimprovedStepCount(AbstractSolverPhaseScope solverPhaseScope) {
        int bestStepIndex = solverPhaseScope.getBestSolutionStepIndex();
        int lastStepIndex = solverPhaseScope.getLastCompletedStepScope().getStepIndex();
        return lastStepIndex - bestStepIndex;
    }
}

