/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.move.decorator;

import java.util.Random;
import org.drools.planner.core.heuristic.selector.SelectorTestUtils;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.move.MoveSelector;
import org.drools.planner.core.heuristic.selector.move.decorator.ShufflingMoveSelector;
import org.drools.planner.core.move.DummyMove;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.testdata.util.PlannerAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ShufflingMoveSelectorTest {
    @Test
    public void cacheTypeSolver() {
        this.run(SelectionCacheType.SOLVER, 1);
    }

    @Test
    public void cacheTypePhase() {
        this.run(SelectionCacheType.PHASE, 2);
    }

    @Test
    public void cacheTypeStep() {
        this.run(SelectionCacheType.STEP, 3);
    }

    public void run(SelectionCacheType cacheType, int timesCalled) {
        MoveSelector childMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("a1"), new DummyMove("a2"), new DummyMove("a3"));
        ShufflingMoveSelector moveSelector = new ShufflingMoveSelector(childMoveSelector, cacheType);
        ((MoveSelector)Mockito.verify((Object)childMoveSelector, (VerificationMode)Mockito.times((int)1))).isNeverEnding();
        Random workingRandom = (Random)Mockito.mock(Random.class);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeA.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA1.getWorkingRandom()).thenReturn((Object)workingRandom);
        Mockito.when((Object)workingRandom.nextInt(3)).thenReturn((Object)2);
        Mockito.when((Object)workingRandom.nextInt(2)).thenReturn((Object)0);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfEndingMoveSelector((MoveSelector)moveSelector, "a2", "a1", "a3");
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA2.getWorkingRandom()).thenReturn((Object)workingRandom);
        Mockito.when((Object)workingRandom.nextInt(3)).thenReturn((Object)0);
        Mockito.when((Object)workingRandom.nextInt(2)).thenReturn((Object)1);
        moveSelector.stepStarted(stepScopeA2);
        if (cacheType.compareTo((Enum)SelectionCacheType.STEP) > 0) {
            PlannerAssert.assertAllCodesOfEndingMoveSelector((MoveSelector)moveSelector, "a3", "a1", "a2");
        } else {
            PlannerAssert.assertAllCodesOfEndingMoveSelector((MoveSelector)moveSelector, "a3", "a2", "a1");
        }
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeB.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB1.getWorkingRandom()).thenReturn((Object)workingRandom);
        Mockito.when((Object)workingRandom.nextInt(3)).thenReturn((Object)1);
        Mockito.when((Object)workingRandom.nextInt(2)).thenReturn((Object)0);
        moveSelector.stepStarted(stepScopeB1);
        if (cacheType.compareTo((Enum)SelectionCacheType.PHASE) > 0) {
            PlannerAssert.assertAllCodesOfEndingMoveSelector((MoveSelector)moveSelector, "a2", "a3", "a1");
        } else {
            PlannerAssert.assertAllCodesOfEndingMoveSelector((MoveSelector)moveSelector, "a3", "a1", "a2");
        }
        moveSelector.stepEnded(stepScopeB1);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelector, 1, 2, 3);
        ((MoveSelector)Mockito.verify((Object)childMoveSelector, (VerificationMode)Mockito.times((int)timesCalled))).iterator();
        ((MoveSelector)Mockito.verify((Object)childMoveSelector, (VerificationMode)Mockito.times((int)timesCalled))).getSize();
    }
}

