/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.testdata.util;

import java.util.Iterator;
import org.drools.planner.core.heuristic.selector.move.MoveSelector;
import org.drools.planner.core.move.CompositeMove;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.testdata.util.CodeAssertable;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlannerAssert
extends Assert {
    public static void assertInstanceOf(Class expectedClass, Object actualInstance) {
        PlannerAssert.assertInstanceOf(null, expectedClass, actualInstance);
    }

    public static void assertInstanceOf(String message, Class expectedClass, Object actualInstance) {
        if (!expectedClass.isInstance(actualInstance)) {
            String cleanMessage = message == null ? "" : message;
            throw new ComparisonFailure(cleanMessage, expectedClass.getName(), actualInstance == null ? "null" : actualInstance.getClass().getName());
        }
    }

    public static void assertNotInstanceOf(Class expectedClass, Object actualInstance) {
        PlannerAssert.assertNotInstanceOf(null, expectedClass, actualInstance);
    }

    public static void assertNotInstanceOf(String message, Class expectedClass, Object actualInstance) {
        if (expectedClass.isInstance(actualInstance)) {
            String cleanMessage = message == null ? "" : message;
            throw new ComparisonFailure(cleanMessage, "not " + expectedClass.getName(), actualInstance == null ? "null" : actualInstance.getClass().getName());
        }
    }

    public static void verifySolverPhaseLifecycle(SolverPhaseLifecycleListener lifecycleListener, int solvingCount, int phaseCount, int stepCount) {
        ((SolverPhaseLifecycleListener)Mockito.verify((Object)lifecycleListener, (VerificationMode)Mockito.times((int)solvingCount))).solvingStarted((DefaultSolverScope)Matchers.any());
        ((SolverPhaseLifecycleListener)Mockito.verify((Object)lifecycleListener, (VerificationMode)Mockito.times((int)phaseCount))).phaseStarted((AbstractSolverPhaseScope)Matchers.any());
        ((SolverPhaseLifecycleListener)Mockito.verify((Object)lifecycleListener, (VerificationMode)Mockito.times((int)stepCount))).stepStarted((AbstractStepScope)Matchers.any());
        ((SolverPhaseLifecycleListener)Mockito.verify((Object)lifecycleListener, (VerificationMode)Mockito.times((int)stepCount))).stepEnded((AbstractStepScope)Matchers.any());
        ((SolverPhaseLifecycleListener)Mockito.verify((Object)lifecycleListener, (VerificationMode)Mockito.times((int)phaseCount))).phaseEnded((AbstractSolverPhaseScope)Matchers.any());
        ((SolverPhaseLifecycleListener)Mockito.verify((Object)lifecycleListener, (VerificationMode)Mockito.times((int)solvingCount))).solvingEnded((DefaultSolverScope)Matchers.any());
    }

    private static CodeAssertable convertToCodeAssertable(Object o) {
        PlannerAssert.assertNotNull((Object)o);
        if (o instanceof CodeAssertable) {
            return (CodeAssertable)o;
        }
        if (o instanceof CompositeMove) {
            CompositeMove compositeMove = (CompositeMove)o;
            StringBuilder codeBuilder = new StringBuilder(compositeMove.getMoveList().size() * 80);
            for (Move move : compositeMove.getMoveList()) {
                codeBuilder.append("+").append(PlannerAssert.convertToCodeAssertable(move).getCode());
            }
            final String code = codeBuilder.substring(1);
            return new CodeAssertable(){

                public String getCode() {
                    return code;
                }
            };
        }
        throw new AssertionError((Object)("o's class (" + o.getClass() + ") cannot be converted to CodeAssertable."));
    }

    public static void assertCode(String expectedCode, Object o) {
        CodeAssertable codeAssertable = PlannerAssert.convertToCodeAssertable(o);
        PlannerAssert.assertCode(expectedCode, codeAssertable);
    }

    public static void assertCode(String message, String expectedCode, Object o) {
        CodeAssertable codeAssertable = PlannerAssert.convertToCodeAssertable(o);
        PlannerAssert.assertCode(message, expectedCode, codeAssertable);
    }

    public static void assertCode(String expectedCode, CodeAssertable codeAssertable) {
        PlannerAssert.assertEquals((Object)expectedCode, (Object)codeAssertable.getCode());
    }

    public static void assertCode(String message, String expectedCode, CodeAssertable codeAssertable) {
        PlannerAssert.assertEquals((String)message, (Object)expectedCode, (Object)codeAssertable.getCode());
    }

    public static <O> void assertCodesOfIterator(Iterator<O> iterator, String ... codes) {
        PlannerAssert.assertNotNull(iterator);
        for (String code : codes) {
            PlannerAssert.assertTrue((boolean)iterator.hasNext());
            PlannerAssert.assertCode(code, iterator.next());
        }
    }

    public static void assertAllCodesOfEndingMoveSelector(MoveSelector moveSelector, String ... codes) {
        PlannerAssert.assertAllCodesOfEndingMoveSelector(moveSelector, codes.length, codes);
    }

    public static void assertAllCodesOfEndingMoveSelector(MoveSelector moveSelector, long size, String ... codes) {
        Iterator iterator = moveSelector.iterator();
        PlannerAssert.assertCodesOfIterator(iterator, codes);
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)size, (long)moveSelector.getSize());
    }

    public static void assertCodesOfNeverEndingMoveSelector(MoveSelector moveSelector, String ... codes) {
        PlannerAssert.assertCodesOfNeverEndingMoveSelector(moveSelector, codes.length, codes);
    }

    public static void assertCodesOfNeverEndingMoveSelector(MoveSelector moveSelector, long size, String ... codes) {
        Iterator iterator = moveSelector.iterator();
        PlannerAssert.assertCodesOfIterator(iterator, codes);
        PlannerAssert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isContinuous());
        PlannerAssert.assertEquals((Object)true, (Object)moveSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)size, (long)moveSelector.getSize());
    }

    private PlannerAssert() {
    }
}

