/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.entity;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.entity.FromSolutionEntitySelector;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.testdata.domain.TestdataEntity;
import org.drools.planner.core.testdata.domain.TestdataSolution;
import org.drools.planner.core.testdata.util.PlannerAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FromSolutionEntitySelectorTest {
    @Test
    public void originalAndCacheTypeSolver() {
        this.runOriginalAndCacheType(SelectionCacheType.SOLVER, 1);
    }

    @Test
    public void originalAndCacheTypePhase() {
        this.runOriginalAndCacheType(SelectionCacheType.PHASE, 2);
    }

    @Test
    public void originalAndCacheTypeStep() {
        this.runOriginalAndCacheType(SelectionCacheType.STEP, 5);
    }

    public void runOriginalAndCacheType(SelectionCacheType cacheType, int timesCalled) {
        TestdataSolution workingSolution = new TestdataSolution();
        List<Object> entityList = Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3"));
        PlanningEntityDescriptor entityDescriptor = (PlanningEntityDescriptor)Mockito.mock(PlanningEntityDescriptor.class);
        Mockito.when((Object)entityDescriptor.extractEntities((Solution)workingSolution)).thenReturn(entityList);
        FromSolutionEntitySelector entitySelector = new FromSolutionEntitySelector(entityDescriptor, cacheType, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getWorkingSolution()).thenReturn((Object)workingSolution);
        entitySelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        entitySelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        entitySelector.stepStarted(stepScopeA1);
        this.runOriginalAsserts(entitySelector, "e1", "e2", "e3");
        entitySelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        entitySelector.stepStarted(stepScopeA2);
        this.runOriginalAsserts(entitySelector, "e1", "e2", "e3");
        entitySelector.stepEnded(stepScopeA2);
        entitySelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        entitySelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB1);
        this.runOriginalAsserts(entitySelector, "e1", "e2", "e3");
        entitySelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB2);
        this.runOriginalAsserts(entitySelector, "e1", "e2", "e3");
        entitySelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB3);
        this.runOriginalAsserts(entitySelector, "e1", "e2", "e3");
        entitySelector.stepEnded(stepScopeB3);
        entitySelector.phaseEnded(phaseScopeB);
        entitySelector.solvingEnded(solverScope);
        ((PlanningEntityDescriptor)Mockito.verify((Object)entityDescriptor, (VerificationMode)Mockito.times((int)timesCalled))).extractEntities((Solution)workingSolution);
    }

    private void runOriginalAsserts(FromSolutionEntitySelector entitySelector, String ... codes) {
        Iterator iterator = entitySelector.iterator();
        Assert.assertNotNull((Object)iterator);
        for (String code : codes) {
            Assert.assertTrue((boolean)iterator.hasNext());
            PlannerAssert.assertCode(code, iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)false, (Object)entitySelector.isContinuous());
        Assert.assertEquals((Object)false, (Object)entitySelector.isNeverEnding());
        Assert.assertEquals((long)3L, (long)entitySelector.getSize());
    }

    @Test
    public void randomAndCacheTypeSolver() {
        this.runRandomAndCacheType(SelectionCacheType.SOLVER, 1);
    }

    @Test
    public void randomAndCacheTypePhase() {
        this.runRandomAndCacheType(SelectionCacheType.PHASE, 2);
    }

    @Test
    public void randomAndCacheTypeStep() {
        this.runRandomAndCacheType(SelectionCacheType.STEP, 5);
    }

    public void runRandomAndCacheType(SelectionCacheType cacheType, int timesCalled) {
        TestdataSolution workingSolution = new TestdataSolution();
        List<Object> entityList = Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3"));
        PlanningEntityDescriptor entityDescriptor = (PlanningEntityDescriptor)Mockito.mock(PlanningEntityDescriptor.class);
        Mockito.when((Object)entityDescriptor.extractEntities((Solution)workingSolution)).thenReturn(entityList);
        FromSolutionEntitySelector entitySelector = new FromSolutionEntitySelector(entityDescriptor, cacheType, true);
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextInt(3)).thenReturn((Object)1, (Object[])new Integer[]{0, 0, 2, 1, 2, 2, 1, 0});
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getWorkingSolution()).thenReturn((Object)workingSolution);
        Mockito.when((Object)solverScope.getWorkingRandom()).thenReturn((Object)workingRandom);
        entitySelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        entitySelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        entitySelector.stepStarted(stepScopeA1);
        this.runRandomAsserts(entitySelector, "e2", "e1", "e1", "e3");
        entitySelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        entitySelector.stepStarted(stepScopeA2);
        this.runRandomAsserts(entitySelector, "e2", "e3");
        entitySelector.stepEnded(stepScopeA2);
        entitySelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        entitySelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB1);
        this.runRandomAsserts(entitySelector, "e3");
        entitySelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB2);
        this.runRandomAsserts(entitySelector, "e2");
        entitySelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB3);
        this.runRandomAsserts(entitySelector, "e1");
        entitySelector.stepEnded(stepScopeB3);
        entitySelector.phaseEnded(phaseScopeB);
        entitySelector.solvingEnded(solverScope);
        ((PlanningEntityDescriptor)Mockito.verify((Object)entityDescriptor, (VerificationMode)Mockito.times((int)timesCalled))).extractEntities((Solution)workingSolution);
    }

    private void runRandomAsserts(FromSolutionEntitySelector entitySelector, String ... codes) {
        Iterator iterator = entitySelector.iterator();
        Assert.assertNotNull((Object)iterator);
        for (String code : codes) {
            Assert.assertTrue((boolean)iterator.hasNext());
            PlannerAssert.assertCode(code, iterator.next());
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)false, (Object)entitySelector.isContinuous());
        Assert.assertEquals((Object)true, (Object)entitySelector.isNeverEnding());
        Assert.assertEquals((long)3L, (long)entitySelector.getSize());
    }
}

