/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.move.generic.chained;

import java.util.Arrays;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.SelectorTestUtils;
import org.drools.planner.core.heuristic.selector.move.generic.chained.SubChainSwapMove;
import org.drools.planner.core.heuristic.selector.value.chained.SubChain;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.testdata.domain.TestdataChainedAnchor;
import org.drools.planner.core.testdata.domain.TestdataChainedEntity;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SubChainSwapMoveTest {
    @Test
    public void noTrailing() {
        PlanningEntityDescriptor entityDescriptor = TestdataChainedEntity.buildEntityDescriptor();
        PlanningVariableDescriptor variableDescriptor = entityDescriptor.getPlanningVariableDescriptor("chainedObject");
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        TestdataChainedEntity b3 = new TestdataChainedEntity("b3", b2);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1, b2, b3});
        SubChainSwapMove move = new SubChainSwapMove(variableDescriptor, new SubChain(Arrays.asList(a3, a4, a5)), new SubChain(Arrays.asList(b2, b3)));
        Move undoMove = move.createUndoMove(scoreDirector);
        move.doMove(scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, b2, b3);
        SelectorTestUtils.assertChain(b0, b1, a3, a4, a5);
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a3, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a3, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a4, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a4, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a5, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a5, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeastOnce())).beforeVariableChanged((Object)b2, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeastOnce())).afterVariableChanged((Object)b2, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)b3, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)b3, "chainedObject");
        undoMove.doMove(scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        SelectorTestUtils.assertChain(b0, b1, b2, b3);
    }

    @Test
    public void oldAndNewTrailing() {
        PlanningEntityDescriptor entityDescriptor = TestdataChainedEntity.buildEntityDescriptor();
        PlanningVariableDescriptor variableDescriptor = entityDescriptor.getPlanningVariableDescriptor("chainedObject");
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        TestdataChainedEntity b3 = new TestdataChainedEntity("b3", b2);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1, b2, b3});
        SubChainSwapMove move = new SubChainSwapMove(variableDescriptor, new SubChain(Arrays.asList(a2, a3, a4)), new SubChain(Arrays.asList(b1, b2)));
        Move undoMove = move.createUndoMove(scoreDirector);
        move.doMove(scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, b1, b2, a5);
        SelectorTestUtils.assertChain(b0, a2, a3, a4, b3);
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a2, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a2, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a3, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a3, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a4, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a4, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeastOnce())).beforeVariableChanged((Object)a5, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeastOnce())).afterVariableChanged((Object)a5, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeastOnce())).beforeVariableChanged((Object)b1, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeastOnce())).afterVariableChanged((Object)b1, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)b2, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)b2, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)b3, "chainedObject");
        ((ScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)b3, "chainedObject");
        undoMove.doMove(scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        SelectorTestUtils.assertChain(b0, b1, b2, b3);
    }
}

