/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.constructionheuristic.placer.entity;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.constructionheuristic.placer.entity.EntityPlacerConfig;
import org.drools.planner.config.constructionheuristic.placer.value.ValuePlacerConfig;
import org.drools.planner.config.heuristic.selector.common.SelectionOrder;
import org.drools.planner.config.heuristic.selector.entity.EntitySelectorConfig;
import org.drools.planner.core.constructionheuristic.placer.entity.QueuedEntityPlacer;
import org.drools.planner.core.constructionheuristic.placer.value.ValuePlacer;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.termination.Termination;

@XStreamAlias(value="queuedEntityPlacer")
public class QueuedEntityPlacerConfig
extends EntityPlacerConfig {
    @XStreamAlias(value="entitySelector")
    protected EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
    @XStreamAlias(value="valuePlacer")
    protected ValuePlacerConfig valuePlacerConfig = new ValuePlacerConfig();

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public ValuePlacerConfig getValuePlacerConfig() {
        return this.valuePlacerConfig;
    }

    public void setValuePlacerConfig(ValuePlacerConfig valuePlacerConfig) {
        this.valuePlacerConfig = valuePlacerConfig;
    }

    public QueuedEntityPlacer buildEntityPlacer(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, Termination phaseTermination) {
        EntitySelector entitySelector = this.entitySelectorConfig.buildEntitySelector(environmentMode, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.ORIGINAL);
        ValuePlacer valuePlacer = this.valuePlacerConfig.buildValuePlacer(environmentMode, solutionDescriptor, phaseTermination, entitySelector.getEntityDescriptor());
        return new QueuedEntityPlacer(entitySelector, valuePlacer);
    }

    public void inherit(QueuedEntityPlacerConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.entitySelectorConfig == null) {
            this.entitySelectorConfig = inheritedConfig.getEntitySelectorConfig();
        } else if (inheritedConfig.getEntitySelectorConfig() != null) {
            this.entitySelectorConfig.inherit(inheritedConfig.getEntitySelectorConfig());
        }
        if (this.valuePlacerConfig == null) {
            this.valuePlacerConfig = inheritedConfig.getValuePlacerConfig();
        } else if (inheritedConfig.getValuePlacerConfig() != null) {
            this.valuePlacerConfig.inherit(inheritedConfig.getValuePlacerConfig());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + ", " + this.valuePlacerConfig + ")";
    }
}

