/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.constructionheuristic.greedyFit;

import java.util.Iterator;
import org.drools.planner.core.constructionheuristic.greedyFit.GreedyFitSolverPhase;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.GreedyDecider;
import org.drools.planner.core.constructionheuristic.greedyFit.scope.GreedyFitSolverPhaseScope;
import org.drools.planner.core.constructionheuristic.greedyFit.scope.GreedyFitStepScope;
import org.drools.planner.core.constructionheuristic.greedyFit.selector.GreedyPlanningEntitySelector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public class DefaultGreedyFitSolverPhase
extends AbstractSolverPhase
implements GreedyFitSolverPhase {
    protected GreedyPlanningEntitySelector greedyPlanningEntitySelector;
    protected GreedyDecider greedyDecider;
    protected boolean assertStepScoreIsUncorrupted = false;

    public void setGreedyPlanningEntitySelector(GreedyPlanningEntitySelector greedyPlanningEntitySelector) {
        this.greedyPlanningEntitySelector = greedyPlanningEntitySelector;
    }

    public void setGreedyDecider(GreedyDecider greedyDecider) {
        this.greedyDecider = greedyDecider;
    }

    public void setAssertStepScoreIsUncorrupted(boolean assertStepScoreIsUncorrupted) {
        this.assertStepScoreIsUncorrupted = assertStepScoreIsUncorrupted;
    }

    public void solve(DefaultSolverScope solverScope) {
        GreedyFitSolverPhaseScope phaseScope = new GreedyFitSolverPhaseScope(solverScope);
        this.phaseStarted(phaseScope);
        GreedyFitStepScope stepScope = this.createNextStepScope(phaseScope, null);
        Iterator<Object> it = this.greedyPlanningEntitySelector.iterator();
        while (!this.termination.isPhaseTerminated(phaseScope) && it.hasNext()) {
            Object planningEntity = it.next();
            stepScope.setPlanningEntity(planningEntity);
            this.stepStarted(stepScope);
            this.greedyDecider.decideNextStep(stepScope);
            Move nextStep = stepScope.getStep();
            if (nextStep == null) {
                this.logger.warn("    Cancelled step index ({}), time spend ({}): there is no doable move. Terminating phase early.", (Object)stepScope.getStepIndex(), (Object)phaseScope.calculateSolverTimeMillisSpend());
                break;
            }
            nextStep.doMove(stepScope.getScoreDirector());
            phaseScope.getWorkingSolution().setScore(stepScope.getScore());
            if (this.assertStepScoreIsUncorrupted) {
                phaseScope.assertWorkingScore(stepScope.getScore());
            }
            if (!it.hasNext()) {
                stepScope.setSolutionInitialized(true);
            }
            this.stepEnded(stepScope);
            stepScope = this.createNextStepScope(phaseScope, stepScope);
        }
        this.phaseEnded(phaseScope);
    }

    private GreedyFitStepScope createNextStepScope(GreedyFitSolverPhaseScope greedyFitSolverPhaseScope, GreedyFitStepScope completedGreedyFitStepScope) {
        if (completedGreedyFitStepScope == null) {
            completedGreedyFitStepScope = new GreedyFitStepScope(greedyFitSolverPhaseScope);
            completedGreedyFitStepScope.setScore(greedyFitSolverPhaseScope.getStartingScore());
            completedGreedyFitStepScope.setStepIndex(-1);
        }
        greedyFitSolverPhaseScope.setLastCompletedStepScope(completedGreedyFitStepScope);
        GreedyFitStepScope greedyFitStepScope = new GreedyFitStepScope(greedyFitSolverPhaseScope);
        greedyFitStepScope.setStepIndex(completedGreedyFitStepScope.getStepIndex() + 1);
        greedyFitStepScope.setSolutionInitialized(false);
        return greedyFitStepScope;
    }

    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
    }

    public void phaseStarted(GreedyFitSolverPhaseScope greedyFitSolverPhaseScope) {
        super.phaseStarted(greedyFitSolverPhaseScope);
        this.greedyPlanningEntitySelector.phaseStarted(greedyFitSolverPhaseScope);
        this.greedyDecider.phaseStarted(greedyFitSolverPhaseScope);
    }

    public void stepStarted(GreedyFitStepScope greedyFitStepScope) {
        super.stepStarted(greedyFitStepScope);
        this.greedyPlanningEntitySelector.stepStarted(greedyFitStepScope);
        this.greedyDecider.stepStarted(greedyFitStepScope);
    }

    public void stepEnded(GreedyFitStepScope greedyFitStepScope) {
        super.stepEnded(greedyFitStepScope);
        this.greedyPlanningEntitySelector.stepEnded(greedyFitStepScope);
        this.greedyDecider.stepEnded(greedyFitStepScope);
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpend = greedyFitStepScope.getPhaseScope().calculateSolverTimeMillisSpend();
            this.logger.debug("    Step index ({}), time spend ({}), score ({}), initialized planning entity ({}).", new Object[]{greedyFitStepScope.getStepIndex(), timeMillisSpend, greedyFitStepScope.getScore(), greedyFitStepScope.getPlanningEntity()});
        }
    }

    public void phaseEnded(GreedyFitSolverPhaseScope greedyFitSolverPhaseScope) {
        super.phaseEnded(greedyFitSolverPhaseScope);
        this.greedyPlanningEntitySelector.phaseEnded(greedyFitSolverPhaseScope);
        this.greedyDecider.phaseEnded(greedyFitSolverPhaseScope);
        this.logger.info("Phase constructionHeuristic ended: step total ({}), time spend ({}), best score ({}).", new Object[]{greedyFitSolverPhaseScope.getLastCompletedStepScope().getStepIndex() + 1, greedyFitSolverPhaseScope.calculateSolverTimeMillisSpend(), greedyFitSolverPhaseScope.getBestScore()});
    }

    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
    }
}

