/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.simulatedannealing;

import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;
import org.drools.planner.core.localsearch.scope.LocalSearchMoveScope;
import org.drools.planner.core.localsearch.scope.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.scope.LocalSearchStepScope;
import org.drools.planner.core.score.Score;

public class LegacySimulatedAnnealingAcceptor
extends AbstractAcceptor {
    protected double startingTemperature = -1.0;
    protected double temperatureSurvival = 0.997;
    protected double temperature;

    public void setStartingTemperature(double startingTemperature) {
        this.startingTemperature = startingTemperature;
    }

    public void setTemperatureSurvival(double temperatureSurvival) {
        this.temperatureSurvival = temperatureSurvival;
    }

    public void phaseStarted(LocalSearchSolverPhaseScope phaseScope) {
        if (this.startingTemperature <= 0.0) {
            throw new IllegalArgumentException("The startingTemperature (" + this.startingTemperature + ") cannot be negative or zero.");
        }
        if (this.temperatureSurvival <= 0.0) {
            throw new IllegalArgumentException("The temperatureSurvival (" + this.temperatureSurvival + ") cannot be negative or zero.");
        }
        this.temperature = this.startingTemperature;
    }

    public boolean isAccepted(LocalSearchMoveScope moveScope) {
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = moveScope.getStepScope().getPhaseScope();
        Score lastStepScore = localSearchSolverPhaseScope.getLastCompletedStepScope().getScore();
        Score moveScore = moveScope.getScore();
        if (moveScore.compareTo(lastStepScore) > 0) {
            return true;
        }
        Score scoreDifference = lastStepScore.subtract(moveScore);
        double[] scoreDifferenceLevels = scoreDifference.toDoubleLevels();
        for (int i = 0; i < scoreDifferenceLevels.length - 1; ++i) {
            if (scoreDifferenceLevels[i] == 0.0) continue;
            return false;
        }
        double diff = scoreDifferenceLevels[scoreDifferenceLevels.length - 1];
        double acceptChance = Math.exp(-diff / this.temperature);
        return moveScope.getWorkingRandom().nextDouble() < acceptChance;
    }

    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.temperature *= this.temperatureSurvival;
    }
}

