/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.simulatedannealing;

import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;
import org.drools.planner.core.localsearch.scope.LocalSearchMoveScope;
import org.drools.planner.core.localsearch.scope.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.scope.LocalSearchStepScope;
import org.drools.planner.core.score.Score;

public class SimulatedAnnealingAcceptor
extends AbstractAcceptor {
    protected Score startingTemperature;
    protected int levelsLength = -1;
    protected double[] startingTemperatureLevels;
    protected double[] temperatureLevels;
    protected double temperatureMinimum = 1.0E-100;

    public void setStartingTemperature(Score startingTemperature) {
        this.startingTemperature = startingTemperature;
    }

    public void phaseStarted(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        for (double startingTemperatureLevel : this.startingTemperature.toDoubleLevels()) {
            if (!(startingTemperatureLevel < 0.0)) continue;
            throw new IllegalArgumentException("The startingTemperature (" + this.startingTemperature + ") cannot have negative level (" + startingTemperatureLevel + ").");
        }
        this.startingTemperatureLevels = this.startingTemperature.toDoubleLevels();
        this.temperatureLevels = this.startingTemperatureLevels;
        this.levelsLength = this.startingTemperatureLevels.length;
    }

    public void phaseEnded(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.startingTemperatureLevels = null;
        this.temperatureLevels = null;
        this.levelsLength = -1;
    }

    public boolean isAccepted(LocalSearchMoveScope moveScope) {
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = moveScope.getStepScope().getPhaseScope();
        Score lastStepScore = localSearchSolverPhaseScope.getLastCompletedStepScope().getScore();
        Score moveScore = moveScope.getScore();
        if (moveScore.compareTo(lastStepScore) >= 0) {
            return true;
        }
        Score scoreDifference = lastStepScore.subtract(moveScore);
        double acceptChance = 1.0;
        double[] scoreDifferenceLevels = scoreDifference.toDoubleLevels();
        for (int i = 0; i < this.levelsLength; ++i) {
            double scoreDifferenceLevel = scoreDifferenceLevels[i];
            double temperatureLevel = this.temperatureLevels[i];
            double acceptChanceLevel = scoreDifferenceLevel <= 0.0 ? 1.0 : Math.exp(-scoreDifferenceLevel / temperatureLevel);
            acceptChance *= acceptChanceLevel;
        }
        return moveScope.getWorkingRandom().nextDouble() < acceptChance;
    }

    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        double timeGradient = stepScope.getTimeGradient();
        double reverseTimeGradient = 1.0 - timeGradient;
        this.temperatureLevels = new double[this.levelsLength];
        for (int i = 0; i < this.levelsLength; ++i) {
            this.temperatureLevels[i] = this.startingTemperatureLevels[i] * reverseTimeGradient;
            if (!(this.temperatureLevels[i] < this.temperatureMinimum)) continue;
            this.temperatureLevels[i] = this.temperatureMinimum;
        }
    }
}

