/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.director.incremental;

import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.director.AbstractScoreDirector;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.score.director.incremental.IncrementalScoreCalculator;
import org.drools.planner.core.score.director.incremental.IncrementalScoreDirectorFactory;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalScoreDirector
extends AbstractScoreDirector<IncrementalScoreDirectorFactory> {
    private final IncrementalScoreCalculator incrementalScoreCalculator;

    public IncrementalScoreDirector(IncrementalScoreDirectorFactory scoreDirectorFactory, IncrementalScoreCalculator incrementalScoreCalculator) {
        super(scoreDirectorFactory);
        this.incrementalScoreCalculator = incrementalScoreCalculator;
    }

    @Override
    public void setWorkingSolution(Solution workingSolution) {
        super.setWorkingSolution(workingSolution);
        this.incrementalScoreCalculator.resetWorkingSolution(workingSolution);
    }

    @Override
    public void beforeEntityAdded(Object entity) {
        this.incrementalScoreCalculator.beforeEntityAdded(entity);
        super.beforeEntityAdded(entity);
    }

    @Override
    public void afterEntityAdded(Object entity) {
        super.afterEntityAdded(entity);
        this.incrementalScoreCalculator.afterEntityAdded(entity);
    }

    @Override
    public void beforeAllVariablesChanged(Object entity) {
        this.incrementalScoreCalculator.beforeAllVariablesChanged(entity);
        super.beforeAllVariablesChanged(entity);
    }

    @Override
    public void afterAllVariablesChanged(Object entity) {
        super.afterAllVariablesChanged(entity);
        this.incrementalScoreCalculator.afterAllVariablesChanged(entity);
    }

    @Override
    public void beforeVariableChanged(Object entity, String variableName) {
        this.incrementalScoreCalculator.beforeVariableChanged(entity, variableName);
        super.beforeVariableChanged(entity, variableName);
    }

    @Override
    public void afterVariableChanged(Object entity, String variableName) {
        super.afterVariableChanged(entity, variableName);
        this.incrementalScoreCalculator.afterVariableChanged(entity, variableName);
    }

    @Override
    public void beforeEntityRemoved(Object entity) {
        this.incrementalScoreCalculator.beforeEntityRemoved(entity);
        super.beforeEntityRemoved(entity);
    }

    @Override
    public void afterEntityRemoved(Object entity) {
        super.afterEntityRemoved(entity);
        this.incrementalScoreCalculator.afterEntityRemoved(entity);
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
        super.beforeProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        super.afterProblemFactAdded(problemFact);
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
    }

    @Override
    public void beforeProblemFactChanged(Object problemFact) {
        super.beforeProblemFactChanged(problemFact);
    }

    @Override
    public void afterProblemFactChanged(Object problemFact) {
        super.afterProblemFactChanged(problemFact);
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
        super.beforeProblemFactRemoved(problemFact);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        super.afterProblemFactRemoved(problemFact);
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
    }

    @Override
    public Score calculateScore() {
        Score score = this.incrementalScoreCalculator.calculateScore();
        this.setCalculatedScore(score);
        return score;
    }

    @Override
    protected String buildScoreCorruptionAnalysis(ScoreDirector uncorruptedScoreDirector) {
        if (!(uncorruptedScoreDirector instanceof IncrementalScoreDirector)) {
            return "Unable to analyze: the uncorruptedScoreDirector class (" + uncorruptedScoreDirector.getClass() + ") is not an instance of the scoreDirector class (" + IncrementalScoreDirector.class + ").";
        }
        IncrementalScoreDirector uncorruptedIncrementalScoreDirector = (IncrementalScoreDirector)uncorruptedScoreDirector;
        return this.incrementalScoreCalculator.buildScoreCorruptionAnalysis(uncorruptedIncrementalScoreDirector.incrementalScoreCalculator);
    }
}

