/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.termination;

import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.termination.AbstractCompositeTermination;
import org.drools.planner.core.termination.Termination;

public class AndCompositeTermination
extends AbstractCompositeTermination {
    public AndCompositeTermination() {
    }

    public AndCompositeTermination(Termination ... terminations) {
        super(terminations);
    }

    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        for (Termination termination : this.terminationList) {
            if (termination.isSolverTerminated(solverScope)) continue;
            return false;
        }
        return true;
    }

    public boolean isPhaseTerminated(AbstractSolverPhaseScope phaseScope) {
        for (Termination termination : this.terminationList) {
            if (termination.isPhaseTerminated(phaseScope)) continue;
            return false;
        }
        return true;
    }

    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        double timeGradient = 1.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculateSolverTimeGradient(solverScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.min(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }

    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope phaseScope) {
        double timeGradient = 1.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculatePhaseTimeGradient(phaseScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.min(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }
}

