/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.termination;

import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.termination.AbstractTermination;

public class ScoreAttainedTermination
extends AbstractTermination {
    private Score scoreAttained;

    public void setScoreAttained(Score scoreAttained) {
        this.scoreAttained = scoreAttained;
    }

    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        Score bestScore = solverScope.getBestScore();
        return this.isTerminated(bestScore);
    }

    public boolean isPhaseTerminated(AbstractSolverPhaseScope phaseScope) {
        Score bestScore = phaseScope.getBestScore();
        return this.isTerminated(bestScore);
    }

    private boolean isTerminated(Score bestScore) {
        return bestScore != null && bestScore.compareTo(this.scoreAttained) >= 0;
    }

    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        Score startingInitializedScore = solverScope.getStartingInitializedScore();
        Score bestScore = solverScope.getBestScore();
        return solverScope.getScoreDefinition().calculateTimeGradient(startingInitializedScore, this.scoreAttained, bestScore);
    }

    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope phaseScope) {
        Score startingInitializedScore = phaseScope.getStartingScore();
        Score bestScore = phaseScope.getBestScore();
        return phaseScope.getScoreDefinition().calculateTimeGradient(startingInitializedScore, this.scoreAttained, bestScore);
    }
}

