/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.move.generic;

import java.util.Iterator;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.heuristic.selector.SelectorTestUtils;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.heuristic.selector.move.generic.SwapMove;
import org.drools.planner.core.heuristic.selector.move.generic.SwapMoveSelector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.testdata.domain.TestdataEntity;
import org.drools.planner.core.testdata.util.PlannerAssert;
import org.junit.Test;
import org.mockito.Mockito;

public class SwapMoveSelectorTest {
    @Test
    public void originalLeftEqualsRight() {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new TestdataEntity("a"), new TestdataEntity("b"), new TestdataEntity("c"), new TestdataEntity("d"));
        SwapMoveSelector moveSelector = new SwapMoveSelector(entitySelector, entitySelector, entitySelector.getEntityDescriptor().getPlanningVariableDescriptors(), false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        this.runAssertsOriginalLeftEqualsRight(moveSelector);
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        this.runAssertsOriginalLeftEqualsRight(moveSelector);
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        this.runAssertsOriginalLeftEqualsRight(moveSelector);
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        this.runAssertsOriginalLeftEqualsRight(moveSelector);
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        this.runAssertsOriginalLeftEqualsRight(moveSelector);
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 2, 5);
    }

    private void runAssertsOriginalLeftEqualsRight(SwapMoveSelector moveSelector) {
        Iterator iterator = moveSelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        this.assertNextSwapMove(iterator, "a", "b");
        this.assertNextSwapMove(iterator, "a", "c");
        this.assertNextSwapMove(iterator, "a", "d");
        this.assertNextSwapMove(iterator, "b", "c");
        this.assertNextSwapMove(iterator, "b", "d");
        this.assertNextSwapMove(iterator, "c", "d");
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)6L, (long)moveSelector.getSize());
    }

    @Test
    public void emptyOriginalLeftEqualsRight() {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new Object[0]);
        SwapMoveSelector moveSelector = new SwapMoveSelector(entitySelector, entitySelector, entitySelector.getEntityDescriptor().getPlanningVariableDescriptors(), false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        this.runAssertsEmptyOriginalLeftEqualsRight(moveSelector);
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        this.runAssertsEmptyOriginalLeftEqualsRight(moveSelector);
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        this.runAssertsEmptyOriginalLeftEqualsRight(moveSelector);
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        this.runAssertsEmptyOriginalLeftEqualsRight(moveSelector);
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        this.runAssertsEmptyOriginalLeftEqualsRight(moveSelector);
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 2, 5);
    }

    private void runAssertsEmptyOriginalLeftEqualsRight(SwapMoveSelector moveSelector) {
        Iterator iterator = moveSelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)0L, (long)moveSelector.getSize());
    }

    @Test
    public void originalLeftUnequalsRight() {
        PlanningEntityDescriptor entityDescriptor = (PlanningEntityDescriptor)Mockito.mock(PlanningEntityDescriptor.class);
        Mockito.when((Object)entityDescriptor.getPlanningEntityClass()).thenReturn(TestdataEntity.class);
        EntitySelector leftEntitySelector = SelectorTestUtils.mockEntitySelector(entityDescriptor, new TestdataEntity("a"), new TestdataEntity("b"), new TestdataEntity("c"), new TestdataEntity("d"));
        EntitySelector rightEntitySelector = SelectorTestUtils.mockEntitySelector(entityDescriptor, new TestdataEntity("x"), new TestdataEntity("y"), new TestdataEntity("z"));
        SwapMoveSelector moveSelector = new SwapMoveSelector(leftEntitySelector, rightEntitySelector, leftEntitySelector.getEntityDescriptor().getPlanningVariableDescriptors(), false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        this.runAssertsOriginalLeftUnequalsRight(moveSelector);
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        this.runAssertsOriginalLeftUnequalsRight(moveSelector);
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        this.runAssertsOriginalLeftUnequalsRight(moveSelector);
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        this.runAssertsOriginalLeftUnequalsRight(moveSelector);
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        this.runAssertsOriginalLeftUnequalsRight(moveSelector);
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)leftEntitySelector, 1, 2, 5);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)rightEntitySelector, 1, 2, 5);
    }

    private void runAssertsOriginalLeftUnequalsRight(SwapMoveSelector moveSelector) {
        Iterator iterator = moveSelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        this.assertNextSwapMove(iterator, "a", "x");
        this.assertNextSwapMove(iterator, "a", "y");
        this.assertNextSwapMove(iterator, "a", "z");
        this.assertNextSwapMove(iterator, "b", "x");
        this.assertNextSwapMove(iterator, "b", "y");
        this.assertNextSwapMove(iterator, "b", "z");
        this.assertNextSwapMove(iterator, "c", "x");
        this.assertNextSwapMove(iterator, "c", "y");
        this.assertNextSwapMove(iterator, "c", "z");
        this.assertNextSwapMove(iterator, "d", "x");
        this.assertNextSwapMove(iterator, "d", "y");
        this.assertNextSwapMove(iterator, "d", "z");
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)12L, (long)moveSelector.getSize());
    }

    @Test
    public void emptyRightOriginalLeftUnequalsRight() {
        PlanningEntityDescriptor entityDescriptor = (PlanningEntityDescriptor)Mockito.mock(PlanningEntityDescriptor.class);
        Mockito.when((Object)entityDescriptor.getPlanningEntityClass()).thenReturn(TestdataEntity.class);
        EntitySelector leftEntitySelector = SelectorTestUtils.mockEntitySelector(entityDescriptor, new TestdataEntity("a"), new TestdataEntity("b"), new TestdataEntity("c"), new TestdataEntity("d"));
        EntitySelector rightEntitySelector = SelectorTestUtils.mockEntitySelector(entityDescriptor, new Object[0]);
        SwapMoveSelector moveSelector = new SwapMoveSelector(leftEntitySelector, rightEntitySelector, leftEntitySelector.getEntityDescriptor().getPlanningVariableDescriptors(), false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        this.runAssertsEmptyRightOriginalLeftUnequalsRight(moveSelector);
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        this.runAssertsEmptyRightOriginalLeftUnequalsRight(moveSelector);
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        this.runAssertsEmptyRightOriginalLeftUnequalsRight(moveSelector);
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        this.runAssertsEmptyRightOriginalLeftUnequalsRight(moveSelector);
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        this.runAssertsEmptyRightOriginalLeftUnequalsRight(moveSelector);
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)leftEntitySelector, 1, 2, 5);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)rightEntitySelector, 1, 2, 5);
    }

    private void runAssertsEmptyRightOriginalLeftUnequalsRight(SwapMoveSelector moveSelector) {
        Iterator iterator = moveSelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isNeverEnding());
        PlannerAssert.assertEquals((long)0L, (long)moveSelector.getSize());
    }

    private void assertNextSwapMove(Iterator<Move> iterator, String leftEntityCode, String rightEntityCode) {
        PlannerAssert.assertTrue((boolean)iterator.hasNext());
        SwapMove move = (SwapMove)iterator.next();
        PlannerAssert.assertCode(leftEntityCode, move.getLeftEntity());
        PlannerAssert.assertCode(rightEntityCode, move.getRightEntity());
    }
}

