/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.heuristic.selector.move.generic.chained;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Collection;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.heuristic.selector.common.SelectionOrder;
import org.drools.planner.config.heuristic.selector.move.MoveSelectorConfig;
import org.drools.planner.config.heuristic.selector.value.ValueSelectorConfig;
import org.drools.planner.config.heuristic.selector.value.chained.SubChainSelectorConfig;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.move.MoveSelector;
import org.drools.planner.core.heuristic.selector.move.generic.chained.SubChainChangeMoveSelector;
import org.drools.planner.core.heuristic.selector.value.ValueSelector;
import org.drools.planner.core.heuristic.selector.value.chained.SubChainSelector;

@XStreamAlias(value="subChainChangeMoveSelector")
public class SubChainChangeMoveSelectorConfig
extends MoveSelectorConfig {
    private Class<?> planningEntityClass = null;
    @XStreamAlias(value="subChainSelector")
    private SubChainSelectorConfig subChainSelectorConfig = new SubChainSelectorConfig();
    @XStreamAlias(value="valueSelector")
    private ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
    private Boolean selectReversingMoveToo = null;

    public Class<?> getPlanningEntityClass() {
        return this.planningEntityClass;
    }

    public void setPlanningEntityClass(Class<?> planningEntityClass) {
        this.planningEntityClass = planningEntityClass;
    }

    public SubChainSelectorConfig getSubChainSelectorConfig() {
        return this.subChainSelectorConfig;
    }

    public void setSubChainSelectorConfig(SubChainSelectorConfig subChainSelectorConfig) {
        this.subChainSelectorConfig = subChainSelectorConfig;
    }

    public ValueSelectorConfig getValueSelectorConfig() {
        return this.valueSelectorConfig;
    }

    public void setValueSelectorConfig(ValueSelectorConfig valueSelectorConfig) {
        this.valueSelectorConfig = valueSelectorConfig;
    }

    public Boolean getSelectReversingMoveToo() {
        return this.selectReversingMoveToo;
    }

    public void setSelectReversingMoveToo(Boolean selectReversingMoveToo) {
        this.selectReversingMoveToo = selectReversingMoveToo;
    }

    @Override
    public MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, SelectionOrder resolvedSelectionOrder) {
        PlanningEntityDescriptor entityDescriptor = this.fetchEntityDescriptor(solutionDescriptor);
        SubChainSelector subChainSelector = this.subChainSelectorConfig.buildSubChainSelector(environmentMode, solutionDescriptor, entityDescriptor, minimumCacheType, resolvedSelectionOrder);
        ValueSelector valueSelector = this.valueSelectorConfig.buildValueSelector(environmentMode, solutionDescriptor, entityDescriptor, minimumCacheType, resolvedSelectionOrder);
        return new SubChainChangeMoveSelector(subChainSelector, valueSelector, resolvedSelectionOrder == SelectionOrder.RANDOM, this.selectReversingMoveToo == null ? true : this.selectReversingMoveToo);
    }

    private PlanningEntityDescriptor fetchEntityDescriptor(SolutionDescriptor solutionDescriptor) {
        PlanningEntityDescriptor entityDescriptor;
        if (this.planningEntityClass != null) {
            entityDescriptor = solutionDescriptor.getPlanningEntityDescriptorStrict(this.planningEntityClass);
            if (entityDescriptor == null) {
                throw new IllegalArgumentException("The moveSelectorConfig (" + this + ") has a planningEntityClass (" + this.planningEntityClass + ") that is not configured as a planningEntity.\n" + "If that class (" + this.planningEntityClass.getSimpleName() + ") is not a " + "planningEntityClass (" + solutionDescriptor.getPlanningEntityClassSet() + "), check your Solution implementation's annotated methods.\n" + "If it is, check your solver configuration.");
            }
        } else {
            Collection<PlanningEntityDescriptor> planningEntityDescriptors = solutionDescriptor.getPlanningEntityDescriptors();
            if (planningEntityDescriptors.size() != 1) {
                throw new IllegalArgumentException("The moveSelectorConfig (" + this + ") has no configured planningEntityClass (" + this.planningEntityClass + ") and because there are multiple in the planningEntityClassSet (" + solutionDescriptor.getPlanningEntityClassSet() + "), it can not be deducted automatically.");
            }
            entityDescriptor = planningEntityDescriptors.iterator().next();
        }
        return entityDescriptor;
    }

    public void inherit(SubChainChangeMoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.planningEntityClass = ConfigUtils.inheritOverwritableProperty(this.planningEntityClass, inheritedConfig.getPlanningEntityClass());
        if (this.subChainSelectorConfig == null) {
            this.subChainSelectorConfig = inheritedConfig.getSubChainSelectorConfig();
        } else if (inheritedConfig.getSubChainSelectorConfig() != null) {
            this.subChainSelectorConfig.inherit(inheritedConfig.getSubChainSelectorConfig());
        }
        if (this.valueSelectorConfig == null) {
            this.valueSelectorConfig = inheritedConfig.getValueSelectorConfig();
        } else if (inheritedConfig.getValueSelectorConfig() != null) {
            this.valueSelectorConfig.inherit(inheritedConfig.getValueSelectorConfig());
        }
        this.selectReversingMoveToo = ConfigUtils.inheritOverwritableProperty(this.selectReversingMoveToo, inheritedConfig.getSelectReversingMoveToo());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.subChainSelectorConfig + ", " + this.valueSelectorConfig + ")";
    }
}

